/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.xpath.exp.impl;

import java.net.URI;
import java.util.List;

import org.ow2.easywsdl.schema.api.SchemaElement;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.executable.TExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELExpression;
import com.ebmwebsourcing.easyviper.core.impl.engine.expression.ExpressionImpl;


abstract class AbstractBPELExpressionImpl extends ExpressionImpl<TExpression> implements BPELExpression {

	protected AbstractBPELExpressionImpl(String content, SchemaElement parent) {
		super(new TExpression(), (AbstractSchemaElementImpl) parent);
		setContent(content);
	}
	
	
	protected AbstractBPELExpressionImpl(TExpression model,
			SchemaElement parent) {
		super(model, (AbstractSchemaElementImpl) parent);
	}

	@Override
	public final String getContent() {
		List<Object> contentObjects = getModel().getContent();
		assert contentObjects.size() > 0;
		return String.valueOf(contentObjects.get(0));
	}

	
	private final void setContent(String content) {
		List<Object> contentObjects = getModel().getContent();
		assert contentObjects != null;
		contentObjects.clear();
		contentObjects.add(content);
	}
	
	
	@Override
	public final URI getExpressionLanguage() {
		String expressionLanguage = getModel().getExpressionLanguage();
		return expressionLanguage == null ? null : URI.create(expressionLanguage);
	}

	@Override
	public final void setExpressionLanguage(URI language) {
		getModel().setExpressionLanguage(String.valueOf(language));
	}
	

}
