/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.PartnerLinkValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELInfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELWarningImpl;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Error;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Info;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Warning;
import org.ow2.easywsdl.schema.api.SchemaElement;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.PartnerLinkType;
import org.petalslink.abslayer.service.api.Role;

public class PartnerLinkValidatorImpl
implements PartnerLinkValidator {
    private PartnerLink partnerLink = null;

    public PartnerLinkValidatorImpl(PartnerLink partnerLink) {
        this.partnerLink = partnerLink;
    }

    public void validate() {
        if (!(this.partnerLink.getMyRole() != null && this.partnerLink.getMyRole().trim().length() != 0 || this.partnerLink.getPartnerRole() != null && this.partnerLink.getPartnerRole().trim().length() != 0)) {
            BPELStaticAnalysisImpl.getInstance().addWarning((Warning)new BPELWarningImpl(this.partnerLink, "In PartnerLink " + this.partnerLink.getName() + " => No defined role: neither myRole or partnerRole"));
        }
        BPELProcess process = ScopeUtil.getProcess((SchemaElement)((BPELElement)((BPELElementImpl)this.partnerLink).getParent()));
        if (this.partnerLink.getPartnerLinkType() == null || this.partnerLink.getPartnerLinkType().toString().trim().length() == 0) {
            BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((SchemaElement)this.partnerLink, new BPELException("In PartnerLink " + this.partnerLink.getName() + " => PartnerLinkType cannot be null or empty")));
        } else {
            PartnerLinkType plt = process.getImports().getPartnerLinkType(this.partnerLink.getPartnerLinkType());
            if (plt == null) {
                BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((SchemaElement)this.partnerLink, new BPELException("In PartnerLink " + this.partnerLink.getName() + " => Impossible to find in wsdl descriptions the partnerLinkType: " + this.partnerLink.getPartnerLinkType())));
            } else {
                for (Role r : plt.getRoles()) {
                    Interface itf = process.getImports().findInterface(r.getInterfaceQName());
                    if (itf != null) continue;
                    BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((SchemaElement)this.partnerLink, new BPELException("PartnerLinkType Definition Error => Impossible to find in wsdl descriptions the interface : " + r.getInterfaceQName() + " corresponding to role " + r.getName())));
                }
            }
        }
        if (this.partnerLink.getInitializePartnerRole() != null) {
            BPELStaticAnalysisImpl.getInstance().addInfo((Info)new BPELInfoImpl((BPELElement)this.partnerLink, "[BPEL engine Restriction] In PartnerLink " + this.partnerLink.getName() + " => The value of InitializePartnerRole is ignored : default and unique value for moment = true"));
        }
    }
}

