/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.PartnerLinkType;
import org.petalslink.abslayer.service.api.Role;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.PartnerLinkValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELInfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELWarningImpl;

public class PartnerLinkValidatorImpl implements PartnerLinkValidator {

	private PartnerLink partnerLink = null;
	
	public PartnerLinkValidatorImpl(final PartnerLink partnerLink) {
		this.partnerLink = partnerLink;
	}
	
	public void validate() {
		// validation
			if(((this.partnerLink.getMyRole() == null) || (this.partnerLink.getMyRole().trim().length() == 0))&&
					((this.partnerLink.getPartnerRole() == null) || (this.partnerLink.getPartnerRole().trim().length() == 0))) {
				BPELStaticAnalysisImpl.getInstance().addWarning(new BPELWarningImpl(this.partnerLink, "In PartnerLink " + this.partnerLink.getName() + " => No defined role: neither myRole or partnerRole"));
			}
			final BPELProcess process = ScopeUtil.getProcess((BPELElement) ((BPELElementImpl) this.partnerLink).getParent());

			if((this.partnerLink.getPartnerLinkType() == null) || (this.partnerLink.getPartnerLinkType().toString().trim().length() == 0)) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.partnerLink, new BPELException("In PartnerLink " + this.partnerLink.getName() + " => PartnerLinkType cannot be null or empty")));
			} else {
				final PartnerLinkType plt = process.getImports().getPartnerLinkType(this.partnerLink.getPartnerLinkType());
				if(plt == null) {
					BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.partnerLink, new BPELException("In PartnerLink " + this.partnerLink.getName() + " => Impossible to find in wsdl descriptions the partnerLinkType: " + this.partnerLink.getPartnerLinkType())));
				} else {
					for(final Role r: plt.getRoles()) {
                        Interface itf = process.getImports().findInterface(r.getInterfaceQName());
						if(itf == null) {
							BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.partnerLink, new BPELException("PartnerLinkType Definition Error => Impossible to find in wsdl descriptions the interface : " + 
							        r.getInterfaceQName() + " corresponding to role " + r.getName())));
						}
					}
				}
			}
			if(this.partnerLink.getInitializePartnerRole() != null) {
				BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.partnerLink, "[BPEL engine Restriction] In PartnerLink " + this.partnerLink.getName() + " => The value of InitializePartnerRole is ignored : default and unique value for moment = true"));
			}
	}

}
