/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.fault;

import java.util.List;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.CatchAll;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TActivityContainer;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ActivityImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;

public class CatchAllImpl extends BPELElementImpl<TActivityContainer> implements CatchAll {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	
	private Activity activity = null;

	public CatchAllImpl(final TActivityContainer model, final BPELElement parent) {
		super(Constants._CatchAll_QNAME, model, parent);
		
		// get activity
		try {
			this.activity =  ActivityImpl.analyzeActivityContainer(this.model, this);
		} catch (final BPELException e) {
			final Activity activity = (Activity) this.getParent();
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("In catchAll of " + activity.getName() + " => " + e.getMessage(), e)));
		} 
	}
	

	@Override
	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}

	public Activity getActivity() {
		return this.activity;
	}

	
}
