/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.registry;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.registry.BPELRegistry;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.BPELMessageMatcher;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.AbstractProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.impl.engine.registry.MemoryProcessInstanceRegistryImpl;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Interface;

@Scope(value="COMPOSITE")
@Service(value={BPELRegistry.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class BPELMemoryRegistryImpl
extends AbstractProcessDefinitionRegistry<BPELProcess>
implements BPELRegistry {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(BPELMemoryRegistryImpl.class.getName());

    public BPELProcess getProcessDefinition(ProcessKey name) {
        return (BPELProcess)this.registry.get(name);
    }

    public List<BPELProcess> getAllProcessDefinitions() {
        return new ArrayList<BPELProcess>(this.registry.values());
    }

    public BPELProcess removeProcessDefinition(ProcessKey name, boolean forceUninstall) throws CoreException {
        BPELProcess res = null;
        this.log.finest("Map of instance: " + ((MemoryProcessInstanceRegistryImpl)this.getModel().getCore().getEngine().getProcessInstanceRegistry()).getMap());
        Iterator it = this.getModel().getCore().getEngine().getProcessInstanceRegistry().getProcessInstances(name).iterator();
        ArrayList<Process> undeleteProcess = new ArrayList<Process>();
        while (it.hasNext()) {
            Process p;
            Process process = (Process)it.next();
            if (forceUninstall) {
                this.log.finest("remove process instance: " + process.getName());
                p = this.getModel().getCore().getEngine().getProcessInstanceRegistry().removeProcessInstance(process, forceUninstall);
                if (p != null) {
                    it = this.getModel().getCore().getEngine().getProcessInstanceRegistry().getProcessInstances(name).iterator();
                    continue;
                }
                this.log.warning("Impossible to delete instance: process is null: " + process.getName());
                continue;
            }
            if (process.getExecution() != null && process.getExecution().getState() == Execution.State.ENDED || process.getExecution() == null) {
                this.log.finest("remove process instance: " + process.getName());
                p = this.getModel().getCore().getEngine().getProcessInstanceRegistry().removeProcessInstance(process, forceUninstall);
                if (p != null) {
                    it = this.getModel().getCore().getEngine().getProcessInstanceRegistry().getProcessInstances(name).iterator();
                    continue;
                }
                this.log.warning("Impossible to delete instance, try forceuninstall=true: " + process.getName());
                continue;
            }
            if (undeleteProcess.contains(process)) continue;
            undeleteProcess.add(process);
        }
        if (undeleteProcess.size() > 0) {
            String errorMsg = "";
            for (Process process : undeleteProcess) {
                errorMsg = String.valueOf(errorMsg) + "Impossible to remove this process instance" + process.getName() + " because it is not ended: state = " + process.getExecution().getState() + "\n";
            }
            throw new CoreException(errorMsg);
        }
        res = (BPELProcess)this.registry.remove(name);
        return res;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }

    public List<ProcessKey> createKeys(ProcessDefinition processDefinition) throws CoreException {
        BPELProcess bpelDefinition = (BPELProcess)processDefinition;
        ArrayList<ProcessKey> keys = new ArrayList<ProcessKey>();
        List itfs = bpelDefinition.getProcessInterfaces();
        this.log.finest("Number of interfaces exposed by bpel: " + itfs.size());
        for (Interface itf : itfs) {
            if (itf != null) {
                Collection endpoints = bpelDefinition.getImports().findEndpointsImplementingInterface(itf);
                this.log.finest("Number of endpoints implementing this interface \"" + itf.getQName() + "\" : " + endpoints.size());
                if (!endpoints.isEmpty()) {
                    for (Endpoint endpoint : endpoints) {
                        this.log.finest(endpoint.getName());
                        if (endpoint.getService() != null) {
                            keys.add((ProcessKey)new ProcessKeyImpl(itf.getQName(), endpoint.getService().getQName(), endpoint.getName()));
                            continue;
                        }
                        throw new CoreException("Service not found for this endpoint: " + endpoint.getName() + ". An endpoint MUST be associated to a service.");
                    }
                    continue;
                }
                keys.add((ProcessKey)new ProcessKeyImpl(itf.getQName(), null, null));
                continue;
            }
            keys.add((ProcessKey)new ProcessKeyImpl(processDefinition.getQName(), null, null));
        }
        return keys;
    }

    public <D extends ProcessDefinition> boolean isCreateInstance(D def, Message mess) throws CoreException {
        boolean res = false;
        boolean found = false;
        BPELMessageMatcher matcher = new BPELMessageMatcher(((BPELProcess)def).getImports());
        try {
            List<Receive> receiveActivities = ScopeImpl.findActivityRecursively(Receive.class, ((BPELProcess)def).getActivity());
            if (receiveActivities != null) {
                List<Pick> pickActivities;
                for (Receive r : receiveActivities) {
                    Variable var = ((BPELProcess)def).findVariable(r.getInputVariable());
                    found = matcher.match(var, mess);
                    if (!found) continue;
                    res = r.getCreateInstance();
                    break;
                }
                if (!found && (pickActivities = ScopeImpl.findActivityRecursively(Pick.class, ((BPELProcess)def).getActivity())) != null) {
                    block3: for (Pick pick : pickActivities) {
                        Iterator itOnMessages = pick.getOnMessages().iterator();
                        while (itOnMessages.hasNext() && !found) {
                            OnMessage onM = (OnMessage)itOnMessages.next();
                            Variable var = ((BPELProcess)def).findVariable(onM.getInputVariable());
                            found = matcher.match(var, mess);
                            if (!found) continue;
                            res = pick.getCreateInstance();
                            continue block3;
                        }
                    }
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new CoreException("Check createInstance failed (trying to match on receives or pickcs)" + e.getMessage());
        }
        return res;
    }
}

