/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime;

import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageMatcher;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.BindingOperation;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Message;
import org.petalslink.abslayer.service.api.Operation;
import org.petalslink.abslayer.service.api.Service;

public class BPELMessageMatcher
implements MessageMatcher {
    private Logger log = Logger.getLogger(BPELMessageMatcher.class.getName());
    private final Descriptions desc;

    public BPELMessageMatcher(Descriptions desc) {
        this.desc = desc;
    }

    public boolean match(Variable var, com.ebmwebsourcing.easyviper.core.api.soa.message.Message message) throws CoreException {
        boolean res = false;
        TVariable varDef = (TVariable)((AbstractSchemaElementImpl)var).getModel();
        BindingOperation bindingOperation = null;
        Service service = this.desc.findService(message.getService());
        Endpoint endpoint = service.getEndpoint(message.getEndpoint());
        Interface itf = endpoint.getBinding().getInterface();
        Operation op = itf.getOperation(new QName(itf.getQName().getNamespaceURI(), message.getOperationName()));
        if (op == null) {
            op = itf.getOperation(new QName(itf.getQName().getNamespaceURI(), message.getOperationName()));
            throw new CoreException("Impossible to find " + message.getOperationName() + " in wsdl descriptions");
        }
        Binding binding = endpoint.getBinding();
        if (op != null) {
            if (binding == null) {
                throw new CoreException("Impossible to find binding corresponding to interface: " + itf.getQName());
            }
            if (message.getQName() == null) {
                if (message.getOperationName() != null && message.getService() != null && message.getEndpoint() != null) {
                    bindingOperation = binding.getOperationByName(op.getName());
                    if (bindingOperation != null) {
                        if (bindingOperation.getStyle() == Binding.BindingStyle.DOCUMENT) {
                            this.log.finest("find qname message for document");
                            if (op.getInput() != null) {
                                message.setQName(op.getInput().getMessageName());
                            }
                        } else if (bindingOperation.getStyle() == Binding.BindingStyle.RPC) {
                            this.log.finest("find qname message for rpc");
                            message.setQName(new QName(binding.getInterface().getParentDescription().getTargetNamespace(), op.getName()));
                        }
                    }
                    this.log.finest("Message name setted: " + message.getQName());
                } else {
                    throw new CoreException("The message has no service/endpoint/operation defined.");
                }
            }
        }
        if (message != null && message.getQName() != null) {
            boolean checkName = false;
            if (varDef.getMessageType() != null && varDef.getMessageType().equals(message.getQName())) {
                checkName = true;
            }
            if (!checkName) {
                Message msg = this.desc.findMessage(message.getQName());
                if (bindingOperation == null) {
                    bindingOperation = binding.getOperationByName(op.getName());
                }
                if (bindingOperation.getStyle() == Binding.BindingStyle.DOCUMENT) {
                    Element elmt = msg.getParts()[0].getElement();
                    if (elmt != null && varDef.getElement() != null && varDef.getElement().equals(elmt.inferQName())) {
                        checkName = true;
                    }
                } else if (bindingOperation.getStyle() == Binding.BindingStyle.RPC && message.getQName().getLocalPart().equals(op.getName())) {
                    if (varDef.getMessageType() != null && op.getInput().getMessageName().equals(varDef.getMessageType())) {
                        checkName = true;
                    } else if (varDef.getElement() != null && message.getQName().equals(varDef.getElement())) {
                        checkName = true;
                    }
                }
            }
            if (!checkName && var.getName() != null && var.getName().equals(message.getQName().getLocalPart())) {
                checkName = true;
            }
            if (checkName) {
                this.log.finest("check on name of message: " + message.getQName() + " is ok for variable " + var.getName());
                res = true;
            } else {
                this.log.finest("Error: check on name of message: " + message.getQName() + " is not ok for variable " + var.getName());
            }
        } else {
            this.log.finest("the name of message is null: impossible to check for variable " + var);
        }
        return res;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }
}

