/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Flow;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.FlowValidator;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFlow;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELInfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;

public class FlowValidatorImpl extends ActivityValidatorImpl<Flow> implements FlowValidator {


	public FlowValidatorImpl(final Flow flow) {
		super(flow);
	}

	@Override
	public void validate() {
		// validation

		if((((TFlow)((BPELElementImpl)this.getActivity()).getModel()).getActivity() == null) || (((TFlow)((BPELElementImpl)this.getActivity()).getModel()).getActivity().size() == 0)) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In flow " + this.getActivity().getName() + " => A flow MUST have at less one activity.")));
		}
		
		if((((TFlow)((BPELElementImpl)this.getActivity()).getModel()).getLinks() != null) && (((TFlow)((BPELElementImpl)this.getActivity()).getModel()).getLinks().getLink().size() > 0)) {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.getActivity(), "In flow " + this.getActivity().getName() + " => [BPEL engine restriction] Sorry, but links ares not supported for the moment."));
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In flow " + this.getActivity().getName() + " => [BPEL engine restriction] Sorry, but links ares not supported for the moment.")));
		}
	}

}
