/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Assign;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Empty;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Exit;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Flow;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.ForEach;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.If;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.ReThrow;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.RepeatUntil;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Reply;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Sequence;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Throw;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Wait;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.While;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Copy;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Literal;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Query;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.To;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnAlarm;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtensionActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELError;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELInfo;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELWarning;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.extension.Extension;
import com.ebmwebsourcing.easybpel.model.bpel.api.extension.Extensions;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.Catch;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.FaultHandlers;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELWarningImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.AssignValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.CatchValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.CopyValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.CorrelationSetValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.CorrelationValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.EmptyValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ExitValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ExtensionActivityValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ExtensionValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ExtensionsValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.FaultHandlersValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.FlowValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ForEachValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.FromValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.IfValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ImportValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.InvokeValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.LiteralValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.OnAlarmValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.OnMessageValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.PartnerLinkValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.PickValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ProcessValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.QueryValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ReThrowValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ReceiveValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.RepeatUntilValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ReplyValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ScopeValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.SequenceValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ThrowValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ToValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.VariableValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.WaitValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.WhileValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.tools.URLUtil;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResult;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathError;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathInfo;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathWarning;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.function.DoXslTransformFunctionImpl;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Error;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Info;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Warning;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class BPELValidator {
    private static BPELReader reader = null;
    private static BPELException readerEx = null;
    private final DocumentBuilderFactory factory;

    public static BPELReader getBPELReader() throws BPELException {
        if (readerEx != null) {
            throw readerEx;
        }
        return reader;
    }

    public BPELValidator() throws BPELException {
        BPELValidator.getBPELReader();
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setNamespaceAware(true);
    }

    public ValidatorResult validate(URL bpel) {
        ValidatorResult res = null;
        try {
            URI bpelURI = URLUtil.urlToUri((URL)bpel);
            InputStream is = bpel.openStream();
            Document bpelSrcDoc = this.factory.newDocumentBuilder().parse(is);
            Document bpeltargetDoc = DoXslTransformFunctionImpl.process((URL)Thread.currentThread().getContextClassLoader().getResource("xslt/upperYesAndNoAttribute.xsl"), (Document)bpelSrcDoc, null);
            if (bpeltargetDoc.getDocumentURI() == null) {
                bpeltargetDoc.setDocumentURI(bpelURI.toString());
            }
            res = this.validate(bpeltargetDoc);
        }
        catch (IOException e) {
            res.getErrors().add(new XPathError(null, new BPELException((Throwable)e)));
            e.printStackTrace();
        }
        catch (SAXException e) {
            res.getErrors().add(new XPathError(null, new BPELException((Throwable)e)));
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            res.getErrors().add(new XPathError(null, new BPELException((Throwable)e)));
            e.printStackTrace();
        }
        catch (XPathExpressionException e) {
            res.getErrors().add(new XPathError(null, new BPELException((Throwable)e)));
            e.printStackTrace();
        }
        return res;
    }

    public ValidatorResult validate(Document bpel) {
        ValidatorResult res = null;
        try {
            BPELStaticAnalysisImpl.getInstance().getErrors().clear();
            BPELStaticAnalysisImpl.getInstance().getWarnings().clear();
            BPELStaticAnalysisImpl.getInstance().getInfos().clear();
            res = new ValidatorResult(BPELValidator.getBPELReader().readBPEL(bpel));
            for (Error e : BPELStaticAnalysisImpl.getInstance().getErrors()) {
                res.getErrors().add(new XPathError((BPELError)e));
            }
            for (Warning w : BPELStaticAnalysisImpl.getInstance().getWarnings()) {
                res.getWarnings().add(new XPathWarning((BPELWarning)w));
            }
            for (Info i : BPELStaticAnalysisImpl.getInstance().getInfos()) {
                res.getInfos().add(new XPathInfo((BPELInfo)i));
            }
        }
        catch (BPELException e) {
            res.getErrors().add(new XPathError(null, e));
            e.printStackTrace();
        }
        return res;
    }

    public ValidatorResult validate(BPELProcess bpel) {
        ValidatorResult res = new ValidatorResult(bpel);
        BPELStaticAnalysisImpl.getInstance().getErrors().clear();
        BPELStaticAnalysisImpl.getInstance().getWarnings().clear();
        BPELStaticAnalysisImpl.getInstance().getInfos().clear();
        this.validateElmt((BPELElement)bpel);
        for (Error e : BPELStaticAnalysisImpl.getInstance().getErrors()) {
            res.getErrors().add(new XPathError((BPELError)e));
        }
        for (Warning w : BPELStaticAnalysisImpl.getInstance().getWarnings()) {
            res.getWarnings().add(new XPathWarning((BPELWarning)w));
        }
        for (Info i : BPELStaticAnalysisImpl.getInstance().getInfos()) {
            res.getInfos().add(new XPathInfo((BPELInfo)i));
        }
        return res;
    }

    private void validateElmt(BPELElement elmt) {
        if (elmt != null) {
            if (elmt instanceof BPELProcess) {
                new ProcessValidatorImpl((BPELProcess)elmt).validate();
                for (Import impt : ((BPELProcess)elmt).getImports().getBPELImports()) {
                    this.validateElmt((BPELElement)impt);
                }
                for (PartnerLink pl : ((BPELProcess)elmt).getPartnerLinks()) {
                    this.validateElmt((BPELElement)pl);
                }
                for (BPELVariable var : ((BPELProcess)elmt).getVariables()) {
                    this.validateElmt((BPELElement)var);
                }
                for (CorrelationSet corr : ((BPELProcess)elmt).getCorrelationSets()) {
                    this.validateElmt((BPELElement)corr);
                }
                this.validateElmt((BPELElement)((BPELProcess)elmt).getFaultHandlers());
                this.validateElmt((BPELElement)((BPELProcess)elmt).getExtensions());
                this.validateElmt((BPELElement)((BPELProcess)elmt).getActivity());
            } else if (elmt instanceof Scope) {
                new ScopeValidatorImpl((Scope)elmt).validate();
                for (PartnerLink pl : ((Scope)elmt).getPartnerLinks()) {
                    this.validateElmt((BPELElement)pl);
                }
                for (BPELVariable var : ((Scope)elmt).getVariables()) {
                    this.validateElmt((BPELElement)var);
                }
                this.validateElmt((BPELElement)((Scope)elmt).getFaultHandlers());
                this.validateElmt((BPELElement)((Scope)elmt).getActivity());
            } else if (elmt instanceof Import) {
                new ImportValidatorImpl((Import)elmt).validate();
            } else if (elmt instanceof PartnerLink) {
                new PartnerLinkValidatorImpl((PartnerLink)elmt).validate();
            } else if (elmt instanceof Extensions) {
                new ExtensionsValidatorImpl((Extensions)elmt).validate();
            } else if (elmt instanceof Extension) {
                new ExtensionValidatorImpl((Extension)elmt).validate();
            } else if (elmt instanceof BPELVariable) {
                new VariableValidatorImpl((BPELVariable)elmt).validate();
            } else if (elmt instanceof CorrelationSet) {
                new CorrelationSetValidatorImpl((CorrelationSet)elmt).validate();
            } else if (elmt instanceof Correlation) {
                new CorrelationValidatorImpl((Correlation)elmt).validate();
            } else if (elmt instanceof FaultHandlers) {
                new FaultHandlersValidatorImpl((FaultHandlers)elmt).validate();
                for (Catch c : ((FaultHandlers)elmt).getCatchs()) {
                    this.validateElmt((BPELElement)c);
                }
                this.validateElmt((BPELElement)((FaultHandlers)elmt).getCatchAll());
            } else if (elmt instanceof Catch) {
                new CatchValidatorImpl((Catch)elmt).validate();
                this.validateElmt((BPELElement)((Catch)elmt).getActivity());
            } else if (elmt instanceof Throw) {
                new ThrowValidatorImpl((Throw)elmt).validate();
            } else if (elmt instanceof Receive) {
                new ReceiveValidatorImpl((Receive)elmt).validate();
            } else if (elmt instanceof Reply) {
                new ReplyValidatorImpl((Reply)elmt).validate();
            } else if (elmt instanceof Invoke) {
                new InvokeValidatorImpl((Invoke)elmt).validate();
            } else if (elmt instanceof Wait) {
                new WaitValidatorImpl((Wait)elmt).validate();
            } else if (elmt instanceof Empty) {
                new EmptyValidatorImpl((Empty)elmt).validate();
            } else if (elmt instanceof Sequence) {
                new SequenceValidatorImpl((Sequence)elmt).validate();
                for (Activity a : ((Sequence)elmt).getActivities()) {
                    this.validateElmt((BPELElement)a);
                }
            } else if (elmt instanceof If) {
                new IfValidatorImpl((If)elmt).validate();
                for (Activity a : ((If)elmt).getActivities()) {
                    this.validateElmt((BPELElement)a);
                }
            } else if (elmt instanceof While) {
                new WhileValidatorImpl((While)elmt).validate();
                this.validateElmt((BPELElement)((While)elmt).getActivity());
            } else if (elmt instanceof RepeatUntil) {
                new RepeatUntilValidatorImpl((RepeatUntil)elmt).validate();
                this.validateElmt((BPELElement)((RepeatUntil)elmt).getActivity());
            } else if (elmt instanceof ForEach) {
                new ForEachValidatorImpl((ForEach)elmt).validate();
                this.validateElmt((BPELElement)((ForEach)elmt).getScope());
            } else if (elmt instanceof Pick) {
                new PickValidatorImpl((Pick)elmt).validate();
                for (OnMessage om : ((Pick)elmt).getOnMessages()) {
                    this.validateElmt((BPELElement)om);
                }
                for (OnAlarm oa : ((Pick)elmt).getOnAlarms()) {
                    this.validateElmt((BPELElement)oa);
                }
            } else if (elmt instanceof OnMessage) {
                new OnMessageValidatorImpl((OnMessage)elmt).validate();
            } else if (elmt instanceof OnAlarm) {
                new OnAlarmValidatorImpl((OnAlarm)elmt).validate();
            } else if (elmt instanceof Flow) {
                new FlowValidatorImpl((Flow)elmt).validate();
                for (Activity a : ((Flow)elmt).getActivities()) {
                    this.validateElmt((BPELElement)a);
                }
            } else if (elmt instanceof Exit) {
                new ExitValidatorImpl((Exit)elmt).validate();
            } else if (elmt instanceof ReThrow) {
                new ReThrowValidatorImpl((ReThrow)elmt).validate();
            } else if (elmt instanceof Assign) {
                new AssignValidatorImpl((Assign)elmt).validate();
            } else if (elmt instanceof Copy) {
                new CopyValidatorImpl((Copy)elmt).validate();
            } else if (elmt instanceof From) {
                new FromValidatorImpl((From)elmt).validate();
            } else if (elmt instanceof To) {
                new ToValidatorImpl((To)elmt).validate();
            } else if (elmt instanceof Query) {
                new QueryValidatorImpl((Query)elmt).validate();
            } else if (elmt instanceof Literal) {
                new LiteralValidatorImpl((Literal)elmt).validate();
            } else if (elmt instanceof ExtensionActivity) {
                new ExtensionActivityValidatorImpl((ExtensionActivity)elmt).validate();
            } else {
                BPELStaticAnalysisImpl.getInstance().addWarning((Warning)new BPELWarningImpl(elmt, "this BPLElement " + elmt.getClass() + " has no validator"));
            }
        }
    }

    static {
        try {
            reader = BPELFactoryImpl.getInstance().newBPELReader();
        }
        catch (BPELException e) {
            readerEx = e;
        }
    }
}

