/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator.util;

import java.util.List;
import java.util.logging.Logger;

import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Assign;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Reply;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Copy;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.Catch;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.FaultHandlers;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TImport;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.partnerLink.PartnerLinkImpl;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathExpr;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;

public class XPathBuilder {

	private static Logger log = Logger.getLogger(XPathBuilder.class.getName());

	public static XPathExpr createXPathExpressionFromBPELElement(
			final BPELElement elmt) {
		final XPathExpr res = new XPathExpr();
		res
		.setXPathExpression(XPathBuilder.buildRecursively(elmt, res
				.getNamespaceMapper()));
		return res;
	}

	private static String buildRecursively(final BPELElement element,
			final NamespaceMapperImpl ns) {
		String res = "";
		if (element != null) {
			final BPELElement parent = (BPELElement) ((BPELElementImpl) element)
			.getParent();
			if (parent != null) {
				res = res + XPathBuilder.buildRecursively(parent, ns);
			}

			if (element.getTag() != null) {
				if (element instanceof TVariable) {
					res = res + "/" + Constants._Variables_QNAME.getPrefix()
					+ ":" + Constants._Variables_QNAME.getLocalPart();
					res = res + "/" + element.getTag().getPrefix() + ":"
					+ element.getTag().getLocalPart();

					if ((((Variable) element).getName() != null)) {
						res = res
						+ "[@name=\""
						+ ((Variable) element).getName() + "\"]";
					}
//					final Integer indice = XPathBuilder.findIndiceVariableInVariables((TVariable) element);
//					if (indice != null) {
//						res = res + "[" + indice + "]";
//					}
				} else if (element instanceof BPELExpression) {
					res = res + "/" + element.getTag().getPrefix() + ":"
					+ element.getTag().getLocalPart();

				} else if (element instanceof Import) {
					res = res + "/" + element.getTag().getPrefix() + ":"
					+ element.getTag().getLocalPart();
					final Integer indice = XPathBuilder.findIndiceImportInProcess((Import) element);
					if (indice != null) {
						res = res + "[" + indice + "]";
					}
				} else if (element instanceof CorrelationSet) {
					res = res + "/"
					+ Constants._CorrelationSets_QNAME.getPrefix()
					+ ":"
					+ Constants._CorrelationSets_QNAME.getLocalPart();
					res = res + "/" + element.getTag().getPrefix() + ":"
					+ element.getTag().getLocalPart();
					final Integer indice = XPathBuilder.findIndiceCorrelationSetInProcess((CorrelationSet) element);
					if (indice != null) {
						res = res + "[" + indice + "]";
					}
				} else if (element instanceof Correlation) {
					res = res + "/" + element.getTag().getPrefix() + ":"
					+ element.getTag().getLocalPart();
					final Integer indice = XPathBuilder.findIndiceCorrelationInExchange((Correlation) element);
					if (indice != null) {
						res = res + "[" + indice + "]";
					}
				} else if (element instanceof PartnerLink) {
					res = res + "/" + Constants._PartnerLinks_QNAME.getPrefix()
					+ ":"
					+ Constants._PartnerLinks_QNAME.getLocalPart();
					res = res + "/" + element.getTag().getPrefix() + ":"
					+ element.getTag().getLocalPart();
					if (((PartnerLink) element).getName() != null) {
						res = res + "[@name=\""
						+ ((PartnerLink) element).getName() + "\"]";
					}
					final Integer indice = XPathBuilder.findIndicePartnerLinkInPartnerLinks((PartnerLink) element);
					if (indice != null) {
						res = res + "[" + indice + "]";
					}
				} else if (element instanceof Catch) {
					res = res + "/" + element.getTag().getPrefix() + ":"
					+ element.getTag().getLocalPart();
					final Integer indice = XPathBuilder.findIndiceCatchInParent((Catch) element);
					if (indice != null) {
						res = res + "[" + indice + "]";
					}
				} else if (element instanceof OnMessage) {
					res = res + "/" + element.getTag().getPrefix() + ":"
					+ element.getTag().getLocalPart();
					final Integer indice = XPathBuilder.findIndiceOnMessageInPick((OnMessage) element);
					if (indice != null) {
						res = res + "[" + indice + "]";
					}
				} else if (element instanceof Copy) {
					res = res + "/" + element.getTag().getPrefix() + ":"
					+ element.getTag().getLocalPart();
					final Integer indice = XPathBuilder.findIndiceCopyInAssign((Copy) element);
					if (indice != null) {
						res = res + "[" + indice + "]";
					}
				} else {
					res = res + "/" + element.getTag().getPrefix() + ":"
					+ element.getTag().getLocalPart();
				}
				if (!ns.getNamespaces().containsKey(
						element.getTag().getPrefix())) {
					ns.addNamespace(element.getTag().getPrefix(), element
							.getTag().getNamespaceURI());
				}
				if (element instanceof Activity) {
					if (((Activity) element).getName() != null) {
						res = res + "[@name=\""
						+ ((Activity) element).getName() + "\"]";
					} else {
						res = res + "[@name=\"\"]";
					}
				}
			} else {
				log.severe("this element has no defined tag: " + element);
				res = res + "/" + "UNKNOWN_"
				+ element.getClass().getSimpleName();
			}
		}
		return res;
	}

	private static Integer findIndiceCorrelationInExchange(final Correlation element) {
		Integer res = null;
		int indice = 1;
		List<Correlation> correlation = null;
		final BPELElement parent = (BPELElement) ((BPELElementImpl) element)
		.getParent();
		if (parent instanceof Receive) {
			correlation = ((Receive) parent).getCorrelations();
		} else if (parent instanceof Invoke) {
			correlation = ((Invoke) parent).getCorrelations();
		} else if (parent instanceof Reply) {
			correlation = ((Invoke) parent).getCorrelations();
		}
		if (correlation != null) {
			for (final Correlation item : correlation) {
				if (item == element) {
					res = indice;
					break;
				}
				indice++;
			}
		}
		return res;
	}

	private static Integer findIndiceCatchInParent(final Catch element) {
		Integer res = null;
		int indice = 1;
		List<Catch> _catchs = null;
		final BPELElement parent = (BPELElement) ((BPELElementImpl) element)
		.getParent();
		if (parent instanceof FaultHandlers) {
			_catchs = ((FaultHandlers) parent).getCatchs();
		} else if (parent instanceof Invoke) {
			_catchs = ((Invoke) parent).getCatchs();
		}
		if (_catchs != null) {
			for (final Catch item : _catchs) {
				if (item == element) {
					res = indice;
					break;
				}
				indice++;
			}
		}
		return res;
	}

	private static Integer findIndiceOnMessageInPick(final OnMessage element) {
		Integer res = null;
		int indice = 1;
		List<OnMessage> onMessage = null;
		final BPELElement parent = (BPELElement) ((BPELElementImpl) element)
		.getParent();
		if (parent instanceof Pick) {
			onMessage = ((Pick) parent).getOnMessages();
		}
		if (onMessage != null) {
			for (final OnMessage item : onMessage) {
				if (item == element) {
					res = indice;
					break;
				}
				indice++;
			}
		}
		return res;
	}

	private static Integer findIndiceCopyInAssign(final Copy element) {
		Integer res = null;
		int indice = 1;
		List<Copy> copy = null;
		final BPELElement parent = (BPELElement) ((BPELElementImpl) element)
		.getParent();
		if (parent instanceof Assign) {
			copy = ((Assign) parent).getCopy();
		}
		if (copy != null) {
			for (final Copy item : copy) {
				if (item == element) {
					res = indice;
					break;
				}
				indice++;
			}
		}
		return res;
	}

//	private static Integer findIndiceVariableInVariables(final TVariable var) {
//		Integer res = null;
//		int indice = 1;
//		for (final TVariable item : var.getVariables().getVariable()) {
//			if (item == ((BPELElementImpl) var).getModel()) {
//				res = indice;
//				break;
//			}
//			indice++;
//		}
//		return res;
//	}

	private static Integer findIndiceImportInProcess(final Import element) {
		Integer res = null;
		int indice = 1;
		final BPELProcess process = ScopeUtil.getProcess(element);
		for (final TImport item : (((TProcess) ((BPELElementImpl) process).getModel())
				.getImport())) {
			if (item == ((BPELElementImpl) element).getModel()) {
				res = indice;
				break;
			}
			indice++;
		}
		return res;
	}

	private static Integer findIndiceCorrelationSetInProcess(
			final CorrelationSet element) {
		Integer res = null;
		int indice = 1;
		final BPELProcess process = ScopeUtil.getProcess(element);
		for (final TCorrelationSet item : (((TProcess) ((BPELElementImpl) process)
				.getModel()).getCorrelationSets().getCorrelationSet())) {
			if (item == ((BPELElementImpl) element).getModel()) {
				res = indice;
				break;
			}
			indice++;
		}
		return res;
	}

	private static Integer findIndicePartnerLinkInPartnerLinks(
			final PartnerLink element) {
		Integer res = null;
		int indice = 1;
		final PartnerLinkImpl pl = (PartnerLinkImpl) element;
		for (final TPartnerLink item : pl.getPartnerLinks().getPartnerLink()) {
			if (item == ((BPELElementImpl) element).getModel()) {
				res = indice;
				break;
			}
			indice++;
		}
		return res;
	}
}
