/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Interface;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;

public class AnalysorResult {

	public List<URI> imports = new ArrayList<URI>();

	public List<URI> processDescriptions = new ArrayList<URI>();

	private BPELProcess process = null;

	public AnalysorResult(final BPELProcess process) {
		this.process = process;

		// get all imports
		for (final Import impt : this.process.getImports().getBPELImports()) {
			if (!this.imports.contains(impt.getLocation())) {
				this.imports.add(impt.getLocation());
			}
		}

		// get all process description
		for (final Interface itf : this.process.getProcessInterfaces()) {
			final Description desc = itf.getParentDescription();
			this.processDescriptions.add(desc.getDocumentBaseURI());
		}

	}

	public List<URI> getImports() {
		return this.imports;
	}

	public List<URI> getProcessDescriptions() {
		return this.processDescriptions;
	}

	
	public BPELProcess getProcessDefinition() {
		return this.process;
	}
}
