/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator;

import java.net.URL;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.tools.URLUtil;

public class BPELAnalyser {

	private static BPELReader reader = null;

	private static BPELException readerEx = null;

	static {
		try {
			reader = BPELFactoryImpl.getInstance().newBPELReader();
		} catch (final BPELException e) {
			readerEx = e;
		}

	}

	public static BPELReader getBPELReader() throws BPELException {
		if (readerEx != null) {
			throw readerEx;
		}
		return reader;
	}

	public BPELAnalyser() throws BPELException {
		BPELAnalyser.getBPELReader();
	}

	public AnalysorResult analyze(final URL bpel) throws BPELException {
		AnalysorResult res = null;
		if (bpel == null) {
			throw new BPELException("bpel uri cannot be null!!!");
		}
		
		// clean static analysis
		BPELStaticAnalysisImpl.getInstance().getErrors().clear();
		BPELStaticAnalysisImpl.getInstance().getWarnings().clear();
		BPELStaticAnalysisImpl.getInstance().getInfos().clear();
		
		BPELProcess process = null;
		process = BPELAnalyser.getBPELReader().readBPEL(URLUtil.urlToUri(bpel));
		res = new AnalysorResult(process);
		return res;
	}
	
	public AnalysorResult analyze(final BPELProcess process) throws BPELException {
		AnalysorResult res = null;
		if (process == null) {
			throw new BPELException("process cannot be null!!!");
		}
		
		// clean static analysis
		BPELStaticAnalysisImpl.getInstance().getErrors().clear();
		BPELStaticAnalysisImpl.getInstance().getWarnings().clear();
		BPELStaticAnalysisImpl.getInstance().getInfos().clear();
		
		res = new AnalysorResult(process);
		return res;
	}

}
