/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator;

import java.util.logging.Logger;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELError;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.util.XPathBuilder;

public class XPathError extends BPELErrorImpl {

	private static Logger log = Logger.getLogger(XPathError.class.getName());

	private XPathExpr xpath = null;

	public XPathError(final BPELError e) {
		this((BPELElement) e.getElement(), e.getError());
	}

	public XPathError(final BPELElement elmt, final BPELException e) {
		super(elmt, e);
		this.xpath = XPathBuilder.createXPathExpressionFromBPELElement(elmt);
	}

	public XPathExpr getXpathExpression() {
		return this.xpath;
	}

	public void setXPathExpression(final XPathExpr s) {
		this.xpath = s;
	}

}
