/****************************************************************************
 * Copyright (c) 2010-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easycommons.sca.helper.impl;

import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.extensions.Controller;
import org.objectweb.fractal.fraclet.types.Step;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;

@Scope("COMPOSITE")
@Service(value=SCAComponent.class,names="service")
@PolicySets("frascati:scaEasyPrimitive")
public abstract class SCAComponentImpl implements SCAComponent {

	private static Logger log = Logger.getLogger(SCAComponentImpl.class.getName());
	
	/**
	 * The Frascati scope component
	 */
    @Controller
	private Component component = null;
    
	
    /**
     * Create the component
     */
    @Lifecycle(step = Step.CREATE)
    public void createSCAComponent() throws SCAException {
    	SCAComponentImpl.log.finest("Fractal component created: " + SCAHelper.getSCAHelper().getName(this.getComponent()));
    }

    /**
     * Start the component
     */
    @Lifecycle(step = Step.START)
    public void startSCAComponent() throws SCAException {
    	SCAComponentImpl.log.finest("Fractal component started: " + SCAHelper.getSCAHelper().getName(this.getComponent()));
    }

    /**
     * Stop the component
     */
    @Lifecycle(step = Step.STOP)
    public void stopSCAComponent() throws SCAException {
    	SCAComponentImpl.log.finest("Fractal component stopped: " + SCAHelper.getSCAHelper().getName(this.getComponent()));
    }

    @Lifecycle(step = Step.DESTROY)
    public void destroySCAComponent() throws SCAException {
    	SCAComponentImpl.log.finest("Fractal component destroyed: " + SCAHelper.getSCAHelper().getName(this.getComponent()));
    }


    public Component getComponent() {
		return component;
	}


    public String getName()  {
    	String name = null;
        try {
			name = SCAHelper.getSCAHelper().getName(this.getComponent());
		} catch (SCAException e) {
			// do nothing
		}
		return name;
    }

    public void setName(String name) {
        try {
			SCAHelper.getSCAHelper().changeName(this.getComponent(), name);
		} catch (SCAException e) {
			// do nothing
		}
    }

	
	@Override
	public String toString(){
	    return "SCAComponent " + this.getName();
	}
}
