/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.sca.helper.impl;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.Binding;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easycommons.sca.helper.util.Console;
import com.ebmwebsourcing.easycommons.sca.helper.util.CreateHelloWorld;
import com.ebmwebsourcing.easycommons.sca.helper.util.HelloWorldChildImpl;
import com.ebmwebsourcing.easycommons.sca.helper.util.HelloWorldClient;
import com.ebmwebsourcing.easycommons.sca.helper.util.HelloWorldClientImpl;
import com.ebmwebsourcing.easycommons.sca.helper.util.HelloWorldComposite;
import com.ebmwebsourcing.easycommons.sca.helper.util.HelloWorldCompositeImpl;
import com.ebmwebsourcing.easycommons.sca.helper.util.HelloWorldServiceImpl;
import com.ebmwebsourcing.easycommons.sca.helper.util.HelloWorldSubChildImpl;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.oasisopen.sca.ServiceReference;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

public class SCAHelperTest {
    @Test
    public void createHelloWorld() {
        try {
            Component compositeFc = SCAHelper.getSCAHelper().createNewComponent(HelloWorldCompositeImpl.class.getCanonicalName(), null);
            SCAHelper.getSCAHelper().startComponent(compositeFc);
            HelloWorldComposite composite = (HelloWorldComposite)compositeFc.getFcInterface("service");
            Component server = composite.createServer();
            Component client = composite.createClient();
            SCAHelper.getSCAHelper().addComponent(server, composite.getComponent(), null);
            SCAHelper.getSCAHelper().addComponent(client, composite.getComponent(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void createNewComponentsTest() {
        try {
            Component composite = CreateHelloWorld.createHelloWorld();
            Assert.assertNotNull((Object)composite);
            List children = SCAHelper.getSCAHelper().getComponents(composite);
            Assert.assertEquals((int)2, (int)children.size());
            Assert.assertNotNull(children.get(0));
            Assert.assertNotNull(children.get(1));
        }
        catch (SCAException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void getAllSubComponentsTest() {
        try {
            Component composite = CreateHelloWorld.createHelloWorld();
            Component firstchild = SCAHelper.getSCAHelper().createNewComponent(HelloWorldChildImpl.class.getCanonicalName(), null);
            SCAHelper.getSCAHelper().addComponent(firstchild, composite, null);
            Component newComponent = SCAHelper.getSCAHelper().createNewComponent(HelloWorldSubChildImpl.class.getCanonicalName(), null);
            SCAHelper.getSCAHelper().addComponent(newComponent, firstchild, null);
            Assert.assertNotNull((Object)composite);
            List children = SCAHelper.getSCAHelper().getAllSubComponents(composite);
            Assert.assertEquals((int)4, (int)children.size());
            Assert.assertNotNull(children.get(0));
            Assert.assertNotNull(children.get(1));
            Assert.assertNotNull(children.get(2));
        }
        catch (SCAException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void createNewComponentFailureTest() {
        try {
            Component compositeFc = SCAHelper.getSCAHelper().createNewComponent("BadFactoryClass", null);
            System.out.println(compositeFc);
            Assert.fail();
        }
        catch (SCAException e) {
            Assert.assertNotNull((Object)((Object)e));
        }
    }

    @Test
    public void changeComponentNameTest() {
        try {
            Component composite = CreateHelloWorld.createHelloWorld();
            String nameToBeChecked = "NewName";
            SCAHelper.getSCAHelper().changeName(composite, nameToBeChecked);
            Assert.assertEquals((String)SCAHelper.getSCAHelper().getName(composite), (String)nameToBeChecked);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void componentsByNameTest() {
        try {
            Component composite = CreateHelloWorld.createHelloWorld();
            String clientName = HelloWorldClientImpl.class.getCanonicalName();
            List components = SCAHelper.getSCAHelper().getComponentsByName(composite, clientName);
            Assert.assertEquals((int)1, (int)components.size());
            Assert.assertEquals((String)clientName, (String)SCAHelper.getSCAHelper().getName((Component)components.get(0)));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void firstcomponentsByNameTest() {
        try {
            Component composite = CreateHelloWorld.createHelloWorld();
            String clientName = HelloWorldClientImpl.class.getCanonicalName();
            Component component = SCAHelper.getSCAHelper().getFirstComponentByName(composite, clientName);
            Assert.assertNotNull((Object)component);
            Assert.assertEquals((String)clientName, (String)SCAHelper.getSCAHelper().getName(component));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void boundInterfaceTest() {
        try {
            Component composite = CreateHelloWorld.createHelloWorld();
            this.addBindingToClient(composite);
            String clientName = HelloWorldClientImpl.class.getCanonicalName();
            String serverName = HelloWorldServiceImpl.class.getCanonicalName();
            SCAContentController scacc = (SCAContentController)((Component)SCAHelper.getSCAHelper().getComponentsByName(composite, clientName).get(0)).getFcInterface("/sca-content-controller");
            ServiceReference sr = (ServiceReference)((HelloWorldClient)scacc.getFcContent()).getRef();
            Interface itf = SCAHelper.getSCAHelper().getBoundInterface(sr);
            Assert.assertEquals((String)"service", (String)itf.getFcItfName());
            Assert.assertEquals((String)serverName, (String)SCAHelper.getSCAHelper().getName(itf.getFcItfOwner()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void componentByInterfaceTest() {
        try {
            Component composite = CreateHelloWorld.createHelloWorld();
            this.addBindingToClient(composite);
            String clientName = HelloWorldClientImpl.class.getCanonicalName();
            String serverName = HelloWorldServiceImpl.class.getCanonicalName();
            SCAContentController scacc = (SCAContentController)((Component)SCAHelper.getSCAHelper().getComponentsByName(composite, clientName).get(0)).getFcInterface("/sca-content-controller");
            ServiceReference sr = (ServiceReference)((HelloWorldClient)scacc.getFcContent()).getRef();
            Component c = SCAHelper.getSCAHelper().getComponentByInterface(composite, sr, "service");
            Assert.assertEquals((String)serverName, (String)SCAHelper.getSCAHelper().getName(c));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void clientLinkedToServerTest() {
        try {
            Component composite = CreateHelloWorld.createHelloWorld();
            this.addBindingToClient(composite);
            String clientName = HelloWorldClientImpl.class.getCanonicalName();
            SCAContentController scacc = (SCAContentController)((Component)SCAHelper.getSCAHelper().getComponentsByName(composite, clientName).get(0)).getFcInterface("/sca-content-controller");
            ServiceReference sr = (ServiceReference)((HelloWorldClient)scacc.getFcContent()).getRef();
            Interface itfOfComponent = SCAHelper.getSCAHelper().getBoundInterface(sr);
            List components = SCAHelper.getSCAHelper().getClientComponentsLinkedToServerInterfacesOfComponent(composite, itfOfComponent);
            Assert.assertEquals((int)1, (int)components.size());
            Assert.assertEquals((String)clientName, (String)SCAHelper.getSCAHelper().getName((Component)components.get(0)));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void lifeCycleControllerTest() {
        try {
            Component composite = CreateHelloWorld.createHelloWorld();
            this.addBindingToClient(composite);
            String serverName = HelloWorldServiceImpl.class.getCanonicalName();
            LifeCycleController lc = SCAHelper.getSCAHelper().getLifeCycleControllerByName(composite, serverName);
            lc.stopFc();
            Component server = SCAHelper.getSCAHelper().getFirstComponentByName(composite, serverName);
            Assert.assertFalse((boolean)SCAHelper.getSCAHelper().isStarted(server));
            lc.startFc();
            Assert.assertTrue((boolean)SCAHelper.getSCAHelper().isStarted(server));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void startstopComponentAndSubComponentsTest() {
        try {
            Component composite = CreateHelloWorld.createHelloWorld();
            this.addBindingToClient(composite);
            String clientName = HelloWorldClientImpl.class.getCanonicalName();
            String serverName = HelloWorldServiceImpl.class.getCanonicalName();
            SCAHelper.getSCAHelper().startComponentAndSubComponents(composite);
            Component client = SCAHelper.getSCAHelper().getFirstComponentByName(composite, clientName);
            Component server = SCAHelper.getSCAHelper().getFirstComponentByName(composite, serverName);
            Assert.assertNotNull((Object)client);
            Assert.assertNotNull((Object)server);
            Assert.assertTrue((boolean)SCAHelper.getSCAHelper().isStarted(client));
            Assert.assertTrue((boolean)SCAHelper.getSCAHelper().isStarted(server));
            Assert.assertTrue((boolean)SCAHelper.getSCAHelper().isStarted(composite));
            SCAHelper.getSCAHelper().stopAllSubComponents(composite);
            Assert.assertFalse((boolean)SCAHelper.getSCAHelper().isStarted(client));
            Assert.assertFalse((boolean)SCAHelper.getSCAHelper().isStarted(server));
            Assert.assertTrue((boolean)SCAHelper.getSCAHelper().isStarted(composite));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void addBindingToClient(Component composite) throws SCAException, NoSuchInterfaceException {
        List children = SCAHelper.getSCAHelper().getComponents(composite);
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        Binding binding = new Binding("helloService", (Interface)((Component)children.get(0)).getFcInterface("service"));
        bindings.add(binding);
        Assert.assertNull(SCAHelper.getSCAHelper().getServerInterfacesLinkedToClientInterfacesOfComponent((Component)children.get(1)).get("helloService"));
        SCAHelper.getSCAHelper().addBindings((Component)children.get(1), bindings);
        Assert.assertNotNull(SCAHelper.getSCAHelper().getServerInterfacesLinkedToClientInterfacesOfComponent((Component)children.get(1)).get("helloService"));
    }

    @Test
    public void bindComponentsTest() {
        try {
            Component composite = CreateHelloWorld.createHelloWorld();
            this.addBindingToClient(composite);
            List children = SCAHelper.getSCAHelper().getComponents(composite);
            Assert.assertEquals((int)1, (int)SCAHelper.getSCAHelper().getListOfBinds((Component)children.get(1)).size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void launchHelloWorldTest() {
        try {
            Console.init(System.out, new String[]{"Hello World !!!"});
            Component composite = CreateHelloWorld.createHelloWorld();
            this.addBindingToClient(composite);
            List children = SCAHelper.getSCAHelper().getComponents(composite);
            SCAHelper.getSCAHelper().startComponent(composite);
            SCAHelper.getSCAHelper().startComponent((Component)children.get(0));
            SCAHelper.getSCAHelper().startComponent((Component)children.get(1));
            HelloWorldClient s = (HelloWorldClient)((Component)children.get(1)).getFcInterface("service");
            s.setMessage("Hello World !!!");
            s.run();
            System.out.println();
        }
        catch (SCAException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    private void deleteBindingsFromClient(Component client) throws SCAException, NoSuchInterfaceException {
        Assert.assertEquals((int)1, (int)SCAHelper.getSCAHelper().getListOfBinds(client).size());
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        Binding b = new Binding("helloService", (Interface)SCAHelper.getSCAHelper().getServerInterfacesLinkedToClientInterfacesOfComponent(client).get("helloService"));
        bindings.add(b);
        SCAHelper.getSCAHelper().deleteBindings(client, bindings);
    }

    @Test
    public void deleteBindingsTest() {
        try {
            Component composite = CreateHelloWorld.createHelloWorld();
            List children = SCAHelper.getSCAHelper().getComponents(composite);
            System.out.println(SCAHelper.getSCAHelper().getServerInterfacesLinkedToClientInterfacesOfComponent((Component)children.get(1)));
            Assert.assertNull(SCAHelper.getSCAHelper().getServerInterfacesLinkedToClientInterfacesOfComponent((Component)children.get(1)).get("helloService"));
            this.addBindingToClient(composite);
            Assert.assertNotNull(SCAHelper.getSCAHelper().getServerInterfacesLinkedToClientInterfacesOfComponent((Component)children.get(1)).get("helloService"));
            this.deleteBindingsFromClient((Component)children.get(1));
            Assert.assertNull(SCAHelper.getSCAHelper().getServerInterfacesLinkedToClientInterfacesOfComponent((Component)children.get(1)).get("helloService"));
        }
        catch (SCAException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    private void deleteComponentsFromComposite(Component composite) throws SCAException {
        List children = SCAHelper.getSCAHelper().getComponents(composite);
        Assert.assertEquals((int)2, (int)children.size());
        Component server = (Component)children.get(0);
        Component client = (Component)children.get(1);
        SCAHelper.getSCAHelper().deleteComponent(server);
        Assert.assertEquals((Object)1, (Object)SCAHelper.getSCAHelper().getComponents(composite));
        SCAHelper.getSCAHelper().deleteComponent(client);
    }

    public void deleteComponentsFromComposite() {
        Console.init(System.out, new String[]{"Hello World !!!"});
        try {
            Component composite = CreateHelloWorld.createHelloWorld();
            this.addBindingToClient(composite);
            List children = SCAHelper.getSCAHelper().getComponents(composite);
            SCAHelper.getSCAHelper().startComponent(composite);
            SCAHelper.getSCAHelper().startComponent((Component)children.get(0));
            SCAHelper.getSCAHelper().startComponent((Component)children.get(1));
            this.deleteComponentsFromComposite(composite);
            Assert.assertEquals((Object)0, (Object)SCAHelper.getSCAHelper().getComponents(composite));
        }
        catch (SCAException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

