
package com.ebmwebsourcing.easycommons.thread;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * This class extends the usual {@link ConcurrentHashMap} behaviour by possibly
 * returning a default value from a parent map.
 * 
 * @author mjambert
 * 
 * @param <K>
 * @param <V>
 */
public class ConcurrentHashMapWithDefaults<K, V> extends ConcurrentHashMap<K, V> {

    private static final long serialVersionUID = -636167196756455345L;

    private final Map<K, V> defaults;

    public ConcurrentHashMapWithDefaults() {
        this(new ConcurrentHashMap<K, V>());
    }

    public ConcurrentHashMapWithDefaults(Map<K, V> defaults) {
        assert defaults != null;
        this.defaults = defaults;
    }

    
    public final Map<K, V> getDefaults() {
        return defaults;
    }
    
    public V getValueOrDefault(Object key) {
        if (containsKey(key)) {
            return super.get(key);
        } else if (defaults instanceof ConcurrentHashMapWithDefaults) {
            return ((ConcurrentHashMapWithDefaults<K, V>) defaults).getValueOrDefault(key); 
        } else {
            return defaults.get(key);
        }
    }


    
}
