/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.thread;

import com.ebmwebsourcing.easycommons.thread.InheritableThreadContext;
import com.ebmwebsourcing.easycommons.thread.TestThread;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InheritableThreadContextTest {
    @Before
    public void before() {
        InheritableThreadContext.getParameters().clear();
    }

    @Test
    public void testIsEmptyOnInit() throws Exception {
        Assert.assertTrue((boolean)InheritableThreadContext.getParameters().isEmpty());
    }

    @Test
    public void testIsEmptyAfterPut() throws Exception {
        InheritableThreadContext.getParameters().put((Object)"testKey1", (Object)"testValue1");
        Assert.assertFalse((boolean)InheritableThreadContext.getParameters().isEmpty());
    }

    @Test
    public void testGetWithUnknownKey() throws Exception {
        Assert.assertNull((Object)InheritableThreadContext.getParameters().getValueOrDefault((Object)"testKey1"));
    }

    @Test
    public void testPutAndGet() throws Exception {
        InheritableThreadContext.getParameters().put((Object)"testKey1", (Object)"testValue1");
        Assert.assertEquals((Object)"testValue1", (Object)InheritableThreadContext.getParameters().getValueOrDefault((Object)"testKey1"));
    }

    @Test
    public void testPutTwiceAndGet() throws Exception {
        InheritableThreadContext.getParameters().put((Object)"testKey1", (Object)"testValue1");
        InheritableThreadContext.getParameters().put((Object)"testKey1", (Object)"testValue1");
        Assert.assertEquals((Object)"testValue1", (Object)InheritableThreadContext.getParameters().getValueOrDefault((Object)"testKey1"));
    }

    @Test
    public void testUpdateAndGet() throws Exception {
        InheritableThreadContext.getParameters().put((Object)"testKey1", (Object)"testValue1");
        Assert.assertEquals((Object)"testValue1", (Object)InheritableThreadContext.getParameters().getValueOrDefault((Object)"testKey1"));
        InheritableThreadContext.getParameters().put((Object)"testKey1", (Object)"testValue2");
        Assert.assertEquals((Object)"testValue2", (Object)InheritableThreadContext.getParameters().getValueOrDefault((Object)"testKey1"));
    }

    @Test
    public void testClear() throws Exception {
        InheritableThreadContext.getParameters().put((Object)"testKey1", (Object)"testValue1");
        InheritableThreadContext.getParameters().put((Object)"testKey1", (Object)"testValue2");
        InheritableThreadContext.getParameters().clear();
        Assert.assertTrue((boolean)InheritableThreadContext.getParameters().isEmpty());
    }

    @Test
    public void testReset() throws Exception {
        InheritableThreadContext.getParameters().put((Object)"testKey1", (Object)"testValue1");
        InheritableThreadContext.getParameters().put((Object)"testKey1", (Object)"testValue2");
        InheritableThreadContext.reset();
        Assert.assertTrue((boolean)InheritableThreadContext.getParameters().isEmpty());
    }

    @Test
    public void testPutAndGetAfterReset() throws Exception {
        InheritableThreadContext.getParameters().put((Object)"testKey1", (Object)"oldTestValue1");
        InheritableThreadContext.reset();
        InheritableThreadContext.getParameters().put((Object)"testKey1", (Object)"testValue1");
        Assert.assertEquals((Object)"testValue1", (Object)InheritableThreadContext.getParameters().getValueOrDefault((Object)"testKey1"));
    }

    @Test
    public void testPutInParentThreadClearInChildThreadAndGetInChildThread() throws Exception {
        TestThread tt1 = new TestThread(new Runnable(){

            @Override
            public void run() {
                InheritableThreadContext.getParameters().put((Object)"testKey1", (Object)"testParentValue1");
                TestThread tt2 = new TestThread(new Runnable(){

                    @Override
                    public void run() {
                        InheritableThreadContext.getParameters().put((Object)"testKey1", (Object)"testChildValue1");
                        Assert.assertEquals((Object)"testChildValue1", (Object)InheritableThreadContext.getParameters().getValueOrDefault((Object)"testKey1"));
                        InheritableThreadContext.getParameters().clear();
                        Assert.assertEquals((Object)"testParentValue1", (Object)InheritableThreadContext.getParameters().getValueOrDefault((Object)"testKey1"));
                    }
                });
                tt2.start();
                try {
                    tt2.joinExplosively();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        tt1.start();
        tt1.joinExplosively();
    }

    @Test
    public void testPutAndGetInSiblingThreads() throws Exception {
        TestThread tt1 = new TestThread(new Runnable(){

            @Override
            public void run() {
                InheritableThreadContext.getParameters().put((Object)"testKey1", (Object)"testValue1");
            }
        });
        tt1.start();
        tt1.joinExplosively();
        TestThread tt2 = new TestThread(new Runnable(){

            @Override
            public void run() {
                Assert.assertNull((Object)InheritableThreadContext.getParameters().getValueOrDefault((Object)"testKey1"));
            }
        });
        tt2.start();
        tt2.joinExplosively();
    }

    @Test
    public void testPutInParentThreadAndGetInChildThread() throws Exception {
        TestThread tt1 = new TestThread(new Runnable(){

            @Override
            public void run() {
                InheritableThreadContext.getParameters().put((Object)"testKey1", (Object)"testValue1");
                TestThread tt2 = new TestThread(new Runnable(){

                    @Override
                    public void run() {
                        Assert.assertEquals((Object)"testValue1", (Object)InheritableThreadContext.getParameters().getValueOrDefault((Object)"testKey1"));
                    }
                });
                tt2.start();
                try {
                    tt2.joinExplosively();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        tt1.start();
        tt1.joinExplosively();
    }

    @Test
    public void testPutInChildThreadAndGetInParentThread() throws Exception {
        TestThread tt1 = new TestThread(new Runnable(){

            @Override
            public void run() {
                TestThread tt2 = new TestThread(new Runnable(){

                    @Override
                    public void run() {
                        InheritableThreadContext.getParameters().put((Object)"testKey1", (Object)"testValue1");
                    }
                });
                tt2.start();
                try {
                    tt2.joinExplosively();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                Assert.assertNull((Object)InheritableThreadContext.getParameters().getValueOrDefault((Object)"testKey1"));
            }
        });
        tt1.start();
        tt1.joinExplosively();
    }

    @Test
    public void testPutInParentThreadPutInChildThreadAndGetInBoth() throws Exception {
        TestThread tt1 = new TestThread(new Runnable(){

            @Override
            public void run() {
                InheritableThreadContext.getParameters().put((Object)"testKey1", (Object)"testParentValue1");
                TestThread tt2 = new TestThread(new Runnable(){

                    @Override
                    public void run() {
                        InheritableThreadContext.getParameters().put((Object)"testKey1", (Object)"testChildValue1");
                        Assert.assertEquals((Object)"testChildValue1", (Object)InheritableThreadContext.getParameters().getValueOrDefault((Object)"testKey1"));
                    }
                });
                tt2.start();
                try {
                    tt2.joinExplosively();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                Assert.assertEquals((Object)"testParentValue1", (Object)InheritableThreadContext.getParameters().getValueOrDefault((Object)"testKey1"));
            }
        });
        tt1.start();
        tt1.joinExplosively();
    }
}

