/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.thread;

import com.ebmwebsourcing.easycommons.thread.TestThread;
import org.junit.Assert;
import org.junit.Test;

public class TestThreadTest {
    @Test
    public void testTestThreadNothingThrown() throws Throwable {
        TestThread testThread = new TestThread(new Runnable(){

            @Override
            public void run() {
            }
        });
        testThread.joinExplosively();
    }

    @Test
    public void testTestThreadErrorThrown() throws Exception {
        final OutOfMemoryError thrown = new OutOfMemoryError("This should cause test failure!");
        TestThread testThread = new TestThread(new Runnable(){

            @Override
            public void run() {
                throw thrown;
            }
        });
        try {
            testThread.joinExplosively();
        }
        catch (Throwable e) {
            Assert.assertSame((Object)thrown, (Object)e);
        }
    }

    @Test
    public void testTestThreadRuntimeExceptionThrown() throws Exception {
        final RuntimeException thrown = new RuntimeException("This should cause test failure!");
        TestThread testThread = new TestThread(new Runnable(){

            @Override
            public void run() {
                throw thrown;
            }
        });
        try {
            testThread.joinExplosively();
        }
        catch (Throwable e) {
            Assert.assertSame((Object)thrown, (Object)e);
        }
    }
}

