/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.thread;

import com.ebmwebsourcing.easycommons.properties.PropertiesHelper;
import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import com.ebmwebsourcing.easycommons.thread.TestThread;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExecutionContextTest {
    @Before
    public void before() {
        ExecutionContext.getProperties().clear();
    }

    @Test
    public void testIsEmptyOnInit() throws Exception {
        Assert.assertTrue((boolean)ExecutionContext.getProperties().isEmpty());
    }

    @Test
    public void testIsEmptyAfterPut() throws Exception {
        ExecutionContext.getProperties().setProperty("testKey1", "testValue1");
        Assert.assertFalse((boolean)ExecutionContext.getProperties().isEmpty());
    }

    @Test
    public void testGetWithUnknownKey() throws Exception {
        Assert.assertNull((Object)ExecutionContext.getProperties().getProperty("testKey1"));
    }

    @Test
    public void testPutAndGet() throws Exception {
        ExecutionContext.getProperties().setProperty("testKey1", "testValue1");
        Assert.assertEquals((Object)"testValue1", (Object)ExecutionContext.getProperties().getProperty("testKey1"));
    }

    @Test
    public void testPutTwiceAndGet() throws Exception {
        ExecutionContext.getProperties().setProperty("testKey1", "testValue1");
        ExecutionContext.getProperties().setProperty("testKey1", "testValue1");
        Assert.assertEquals((Object)"testValue1", (Object)ExecutionContext.getProperties().getProperty("testKey1"));
    }

    @Test
    public void testUpdateAndGet() throws Exception {
        ExecutionContext.getProperties().setProperty("testKey1", "testValue1");
        Assert.assertEquals((Object)"testValue1", (Object)ExecutionContext.getProperties().getProperty("testKey1"));
        ExecutionContext.getProperties().setProperty("testKey1", "testValue2");
        Assert.assertEquals((Object)"testValue2", (Object)ExecutionContext.getProperties().getProperty("testKey1"));
    }

    @Test
    public void testClear() throws Exception {
        ExecutionContext.getProperties().setProperty("testKey1", "testValue1");
        ExecutionContext.getProperties().setProperty("testKey1", "testValue2");
        ExecutionContext.getProperties().clear();
        Assert.assertTrue((boolean)ExecutionContext.getProperties().isEmpty());
    }

    @Test
    public void testPutInParentThreadClearInChildThreadAndGetInChildThread() throws Exception {
        TestThread tt1 = new TestThread(new Runnable(){

            @Override
            public void run() {
                ExecutionContext.getProperties().setProperty("testKey1", "testParentValue1");
                TestThread tt2 = new TestThread(new Runnable(){

                    @Override
                    public void run() {
                        ExecutionContext.getProperties().setProperty("testKey1", "testChildValue1");
                        Assert.assertEquals((Object)"testChildValue1", (Object)ExecutionContext.getProperties().getProperty("testKey1"));
                        ExecutionContext.getProperties().clear();
                        Assert.assertEquals((Object)"testParentValue1", (Object)ExecutionContext.getProperties().getProperty("testKey1"));
                    }
                });
                tt2.start();
                try {
                    tt2.joinExplosively();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        tt1.start();
        tt1.joinExplosively();
    }

    @Test
    public void testPutAndGetInSiblingThreads() throws Exception {
        TestThread tt1 = new TestThread(new Runnable(){

            @Override
            public void run() {
                ExecutionContext.getProperties().setProperty("testKey1", "testValue1");
            }
        });
        tt1.start();
        tt1.joinExplosively();
        TestThread tt2 = new TestThread(new Runnable(){

            @Override
            public void run() {
                Assert.assertNull((Object)ExecutionContext.getProperties().getProperty("testKey1"));
            }
        });
        tt2.start();
        tt2.joinExplosively();
    }

    @Test
    public void testPutInParentThreadAndGetInChildThread() throws Exception {
        TestThread tt1 = new TestThread(new Runnable(){

            @Override
            public void run() {
                ExecutionContext.getProperties().setProperty("testKey1", "testValue1");
                TestThread tt2 = new TestThread(new Runnable(){

                    @Override
                    public void run() {
                        Assert.assertEquals((Object)"testValue1", (Object)ExecutionContext.getProperties().getProperty("testKey1"));
                    }
                });
                tt2.start();
                try {
                    tt2.joinExplosively();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        tt1.start();
        tt1.joinExplosively();
    }

    @Test
    public void testPutInChildThreadAndGetInParentThread() throws Exception {
        TestThread tt1 = new TestThread(new Runnable(){

            @Override
            public void run() {
                TestThread tt2 = new TestThread(new Runnable(){

                    @Override
                    public void run() {
                        ExecutionContext.getProperties().setProperty("testKey1", "testValue1");
                    }
                });
                tt2.start();
                try {
                    tt2.joinExplosively();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                Assert.assertNull((Object)ExecutionContext.getProperties().getProperty("testKey1"));
            }
        });
        tt1.start();
        tt1.joinExplosively();
    }

    @Test
    public void testPutInParentThreadPutInChildThreadAndGetInBoth() throws Exception {
        TestThread tt1 = new TestThread(new Runnable(){

            @Override
            public void run() {
                ExecutionContext.getProperties().setProperty("testKey1", "testParentValue1");
                TestThread tt2 = new TestThread(new Runnable(){

                    @Override
                    public void run() {
                        ExecutionContext.getProperties().setProperty("testKey1", "testChildValue1");
                        Assert.assertEquals((Object)"testChildValue1", (Object)ExecutionContext.getProperties().getProperty("testKey1"));
                    }
                });
                tt2.start();
                try {
                    tt2.joinExplosively();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                Assert.assertEquals((Object)"testParentValue1", (Object)ExecutionContext.getProperties().getProperty("testKey1"));
            }
        });
        tt1.start();
        tt1.joinExplosively();
    }

    @Test
    public void testGettingAllPropertiesFromThreadHierarchyLeaf() throws Exception {
        TestThread tt1 = new TestThread(new Runnable(){

            @Override
            public void run() {
                ExecutionContext.getProperties().setProperty("testKey1", "testValue1");
                TestThread tt2 = new TestThread(new Runnable(){

                    @Override
                    public void run() {
                        ExecutionContext.getProperties().setProperty("testKey2", "testValue2");
                        ExecutionContext.getProperties().setProperty("testKey3", "testValue3");
                        TestThread tt3 = new TestThread(new Runnable(){

                            @Override
                            public void run() {
                                ExecutionContext.getProperties().setProperty("testKey3", "testValue3Overriden");
                                ExecutionContext.getProperties().setProperty("testKey4", "testValue4");
                                Properties expectedFlattenPropertes = new Properties();
                                expectedFlattenPropertes.put("testKey1", "testValue1");
                                expectedFlattenPropertes.put("testKey2", "testValue2");
                                expectedFlattenPropertes.put("testKey3", "testValue3Overriden");
                                expectedFlattenPropertes.put("testKey4", "testValue4");
                                Assert.assertEquals((Object)expectedFlattenPropertes, (Object)PropertiesHelper.flattenProperties((Properties)ExecutionContext.getProperties()));
                            }
                        });
                        tt3.start();
                        try {
                            tt3.joinExplosively();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        Properties expectedFlattenPropertes = new Properties();
                        expectedFlattenPropertes.put("testKey1", "testValue1");
                        expectedFlattenPropertes.put("testKey2", "testValue2");
                        expectedFlattenPropertes.put("testKey3", "testValue3");
                        Assert.assertEquals((Object)expectedFlattenPropertes, (Object)PropertiesHelper.flattenProperties((Properties)ExecutionContext.getProperties()));
                    }
                });
                tt2.start();
                try {
                    tt2.joinExplosively();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                Properties expectedFlattenPropertes = new Properties();
                expectedFlattenPropertes.put("testKey1", "testValue1");
                Assert.assertEquals((Object)expectedFlattenPropertes, (Object)PropertiesHelper.flattenProperties((Properties)ExecutionContext.getProperties()));
            }
        });
        tt1.start();
        tt1.joinExplosively();
        Properties expectedFlattenPropertes = new Properties();
        Assert.assertEquals((Object)expectedFlattenPropertes, (Object)PropertiesHelper.flattenProperties((Properties)ExecutionContext.getProperties()));
    }
}

