/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.thread;

import com.ebmwebsourcing.easycommons.thread.TestThread;
import com.ebmwebsourcing.easycommons.thread.WaitingTask;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;

public class SimultaneousTaskExecutor {
    private List<WaitingTask> tasksToExecute = new ArrayList<WaitingTask>();

    public void registerTask(Runnable task) {
        this.tasksToExecute.add(new WaitingTask(task));
    }

    public void clearRegisteredTasks() {
        this.tasksToExecute.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAllRegisteredTasks() throws InterruptedException {
        ArrayList<TestThread> clientPool = new ArrayList<TestThread>();
        Object starterMonitor = new Object();
        Semaphore readyMonitor = new Semaphore(this.tasksToExecute.size());
        for (int i = 0; i < this.tasksToExecute.size(); ++i) {
            readyMonitor.acquire();
            WaitingTask taskToExecute = this.tasksToExecute.get(i);
            taskToExecute.init(readyMonitor, starterMonitor);
            TestThread thread = new TestThread(taskToExecute);
            clientPool.add(thread);
            thread.start();
        }
        readyMonitor.acquire(this.tasksToExecute.size());
        Object i = starterMonitor;
        synchronized (i) {
            starterMonitor.notifyAll();
        }
        for (TestThread thread : clientPool) {
            thread.joinExplosively();
        }
    }
}

