/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.research.util.esb;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import java.net.URI;

public class ESBUtil {
    private static ESBUtil INSTANCE = null;

    private ESBUtil() {
    }

    public static ESBUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ESBUtil();
        }
        return INSTANCE;
    }

    public static EndpointAddress analyzeURI(URI address) throws SOAException {
        EndpointAddress res = null;
        String addr = address.toString().replace("esb://", "");
        String ns = null;
        String serv = null;
        String ep = null;
        if (!addr.contains("@")) {
            throw new SOAException("Endpoint address not valid: " + address);
        }
        if (addr.contains("::")) {
            ns = addr.substring(0, addr.indexOf("::"));
            serv = addr.substring(addr.indexOf("::") + "::".length(), addr.indexOf("@"));
        } else {
            ns = addr.substring(0, addr.indexOf("@"));
        }
        ep = addr.substring(addr.indexOf("@") + "@".length(), addr.length());
        res = new EndpointAddress(ns, serv, ep);
        return res;
    }

    public static URI generateURI(EndpointAddress addr) {
        URI res = null;
        String ref = "esb://";
        ref = String.valueOf(ref) + addr.getNamespace();
        if (addr.getServicename() != null && addr.getServicename().trim().length() > 0) {
            ref = String.valueOf(ref) + "::" + addr.getServicename();
        }
        ref = String.valueOf(ref) + "@" + addr.getEndpointname();
        res = URI.create(ref);
        return res;
    }
}

