/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.research.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public class FileUtil {
    public static File[] getAllDirectories(File parentDir) throws Exception {
        ArrayList<File> list = new ArrayList<File>();
        if (parentDir.isDirectory()) {
            list.addAll(Arrays.asList(parentDir.listFiles()));
            for (File current : list) {
                if (!current.isDirectory()) continue;
                list.addAll(Arrays.asList(FileUtil.getAllDirectories(current)));
            }
        }
        return list.toArray(new File[list.size()]);
    }

    public static File[] getAllFiles(File parentDir) throws Exception {
        ArrayList<File> list = new ArrayList<File>();
        if (parentDir != null) {
            File[] fileArray = FileUtil.getAllDirectories(parentDir);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File dir = fileArray[n2];
                File[] fs = dir.listFiles();
                if (fs != null) {
                    list.addAll(Arrays.asList(fs));
                }
                ++n2;
            }
            list.addAll(Arrays.asList(parentDir.listFiles()));
        }
        return list.toArray(new File[list.size()]);
    }

    public static File createFile(String className, String packageName, String basedir, String extension, boolean override) {
        File f = new File(String.valueOf(basedir) + "/" + packageName.replace(".", "/") + "/" + className + extension);
        if (!override) {
            int cpt = 1;
            while (f.exists()) {
                f = new File(String.valueOf(basedir) + "/" + packageName.replace(".", "/") + "/" + className + "(" + cpt + ")" + extension);
                ++cpt;
            }
        }
        return f;
    }

    public static File createFile(String fileName, String basedir, String extension, boolean override) {
        File f = new File(String.valueOf(basedir) + "/" + fileName + extension);
        if (!override) {
            int cpt = 1;
            while (f.exists()) {
                f = new File(String.valueOf(basedir) + "/" + fileName + "(" + cpt + ")" + extension);
                ++cpt;
            }
        }
        return f;
    }

    public static String createPackageNameFromTargetNamespace(String targetNamespace) {
        URI tns = URI.create(targetNamespace);
        String res = "";
        if (tns.getHost() != null) {
            StringTokenizer st = new StringTokenizer(tns.getHost(), ".");
            while (st.hasMoreTokens()) {
                String part = st.nextToken();
                if (part.equals("www")) continue;
                res = String.valueOf(part) + "." + res;
            }
        }
        res = String.valueOf(res.replace("-", "_")) + tns.getPath().replace("-", "_").replace(".", "_").replace("/", ".").replace("\\", ".").toLowerCase();
        res = res.replace("..", ".");
        if ((res = res.replaceAll("\\.([0-9])", "._$1")).endsWith(".")) {
            res = res.substring(0, res.length() - ".".length());
        }
        return res;
    }

    public static URI getURI(URI baseURI, String relativePath) {
        File file;
        URI res = null;
        res = relativePath.startsWith("file:") ? URI.create(relativePath) : ((file = new File(relativePath)).exists() ? file.toURI() : baseURI.resolve(new String(String.valueOf(baseURI.toString()) + relativePath).trim()));
        return res;
    }

    public static boolean copy(InputStream source, OutputStream destination) {
        boolean resultat = false;
        InputStream sourceFile = null;
        OutputStream destinationFile = null;
        try {
            try {
                int nbLecture;
                sourceFile = source;
                destinationFile = destination;
                byte[] buffer = new byte[524288];
                while ((nbLecture = sourceFile.read(buffer)) != -1) {
                    destinationFile.write(buffer, 0, nbLecture);
                }
                resultat = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    sourceFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    destinationFile.close();
                }
                catch (Exception exception) {
                }
            }
            catch (IOException iOException) {
                try {
                    sourceFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    destinationFile.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                sourceFile.close();
            }
            catch (Exception exception) {}
            try {
                destinationFile.close();
            }
            catch (Exception exception) {}
        }
        return resultat;
    }

    public static String createShortClassName(String clazz) {
        String shortClass = clazz.substring(clazz.lastIndexOf(".") + 1, clazz.length());
        return shortClass;
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    FileUtil.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return path.delete();
    }
}

