/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2006 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package com.petalslink.easycommons.explorer;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;

import javax.swing.JPopupMenu;

/**
 *
 *
 * @author Nicolas SALATGE - eBM WebSourcing
 */
public class MenuMouseExplorer extends JPopupMenu {

	/**
	 * serialVersionUID.
	 */
	private static final long serialVersionUID = 1L;


	private static Logger LOG = Logger.getLogger(MenuMouseExplorer.class.getName());


	private javax.swing.JMenu jMenuPrint;
	private javax.swing.JCheckBoxMenuItem jMenuItemPrintServices;
	private javax.swing.JCheckBoxMenuItem jMenuItemPrintReferences;
	private javax.swing.JCheckBoxMenuItem jMenuItemPrintBindings;
	private javax.swing.JMenuItem jMenuItemRefresh;
	
	private ExplorerView explorer;

	/** Creates a new instance of MenuMouse */
	public MenuMouseExplorer(ExplorerView explorer) {
		this.initComponents();

		this.explorer = explorer;
	}

	private void initComponents() {
		this.jMenuPrint = new javax.swing.JMenu();
		this.jMenuItemPrintServices = new javax.swing.JCheckBoxMenuItem();
		this.jMenuItemPrintReferences = new javax.swing.JCheckBoxMenuItem();
		this.jMenuItemPrintBindings = new javax.swing.JCheckBoxMenuItem();
		this.jMenuItemRefresh = new javax.swing.JMenuItem();

		this.setComponentPopupMenu(this);
		
		
		this.add(this.jMenuItemPrintServices);
		this.add(this.jMenuItemPrintReferences);
		this.add(this.jMenuItemPrintBindings);
		
//		this.jMenuPrint.setText("Print");
//		this.jMenuPrint
//		.addActionListener(new java.awt.event.ActionListener() {
//			public void actionPerformed(
//					final java.awt.event.ActionEvent evt) {
//				MenuMouseExplorer.this
//				.jMenuPrintActionPerformed(evt);
//			}
//		});
//		this.add(this.jMenuPrint);
		
		this.jMenuItemPrintServices.setText("Print Service names");
		this.jMenuItemPrintServices
		.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(
					final java.awt.event.ActionEvent evt) {
				MenuMouseExplorer.this
				.jMenuItemPrintServicesActionPerformed(evt);
			}
		});
		this.add(this.jMenuItemPrintServices);
		
		
		this.jMenuItemPrintReferences.setText("Print Reference names");		
		this.jMenuItemPrintReferences
		.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(
					final java.awt.event.ActionEvent evt) {
				MenuMouseExplorer.this
				.jMenuItemPrintReferencesActionPerformed(evt);
			}
		});
		this.add(this.jMenuItemPrintReferences);
		
		
		this.jMenuItemPrintBindings.setText("Print Binding names");
		this.jMenuItemPrintBindings.setSelected(true);
		this.jMenuItemPrintBindings
		.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(
					final java.awt.event.ActionEvent evt) {
				MenuMouseExplorer.this
				.jMenuItemPrintBindingsActionPerformed(evt);
			}
		});
		this.add(this.jMenuItemPrintBindings);
		
		this.jMenuItemRefresh.setText("Refresh");
		this.jMenuItemRefresh
		.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(
					final java.awt.event.ActionEvent evt) {
				MenuMouseExplorer.this
				.jMenuItemRefreshActionPerformed(evt);
			}
		});
		this.add(this.jMenuItemRefresh);
	}


	protected void jMenuItemPrintServicesActionPerformed(ActionEvent evt) {
		this.explorer.repaint();
		this.setVisible(false);
	}

	protected void jMenuItemPrintReferencesActionPerformed(ActionEvent evt) {
		this.explorer.repaint();
		this.setVisible(false);
	}

	protected void jMenuItemPrintBindingsActionPerformed(ActionEvent evt) {
		this.explorer.repaint();
		this.setVisible(false);
	}

	protected void jMenuItemRefreshActionPerformed(ActionEvent evt) {
		this.explorer.repaint();
		this.setVisible(false);
	}

	public javax.swing.JCheckBoxMenuItem getjMenuItemPrintServices() {
		return jMenuItemPrintServices;
	}

	public javax.swing.JCheckBoxMenuItem getjMenuItemPrintReferences() {
		return jMenuItemPrintReferences;
	}

	public javax.swing.JCheckBoxMenuItem getjMenuItemPrintBindings() {
		return jMenuItemPrintBindings;
	}
}
