/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2006 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package com.petalslink.easycommons.explorer;

import java.util.ArrayList;
import java.util.List;

import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/**
 *
 *
 * @author Nicolas SALATGE - eBM WebSourcing
 */
public class TreeComponentModel implements TreeModel {

	private ComponentG component = null;


	private final List<TreeModelListener> treeModelListeners = new ArrayList<TreeModelListener>();

	public TreeComponentModel(ComponentG component) {
		this.component = component;
	}

	public Object getRoot() {
		return this.component; 
	}

	public Object getChild(final Object parent, final int index) {
		Object res = null;
		if(parent == this.getRoot()) {
			if(index == 0) {
				res = new Components(((ComponentG)parent).getUnderComponents());
			} else if(index == 1) {
				res = new Services(((ComponentG)parent).getServices());
			} else if(index == 2) {
				res = new References(((ComponentG)parent).getReferences());
			} else if(index == 3) {
				res = new Controllers(((ComponentG)parent).getControllers());
			} 
		} else if(parent instanceof ComponentG) {
			if(index == 0) {
				res = new Components(((ComponentG)parent).getUnderComponents());
			} else if(index == 1) {
				res = new Services(((ComponentG)parent).getServices());
			} else if(index == 2) {
				res = new References(((ComponentG)parent).getReferences());
			} else if(index == 3) {
				res = new Controllers(((ComponentG)parent).getControllers());
			} 
		} else if(parent instanceof Components) {
			res = ((Components)parent).getChilds().get(index);
		} else if(parent instanceof Services) {
			res = ((Services)parent).getChilds().get(index);
		} else if(parent instanceof References) {
			res = ((References)parent).getChilds().get(index);
		} else if(parent instanceof Controllers) {
			res = ((Controllers)parent).getChilds().get(index);
		} 
		return res;
	}

	public int getChildCount(final Object parent) {
		int res = 0;
		if(parent == this.getRoot()) {
			res = 4;
		} else if(parent instanceof ComponentG) {
			res = 4;
		} else if(parent instanceof Components) {
			res = ((Components)parent).getChilds().size();
		} else if(parent instanceof Services) {
			res = ((Services)parent).getChilds().size();
		} else if(parent instanceof References) {
			res = ((References)parent).getChilds().size();
		} else if(parent instanceof Controllers) {
			res = ((Controllers)parent).getChilds().size();
		} 
		return res;
	}

	public boolean isLeaf(final Object node) {
		boolean res = true;
		if(node == this.getRoot()) {
			res = false;
		} else if(node instanceof ComponentG) {
			res = false;
		} else if((node instanceof Components)&&(((Components)node).getChilds().size() > 0)) {
			res = false;
		} else if((node instanceof Services)&&(((Services)node).getChilds().size() > 0)) {
			res = false;
		} else if((node instanceof References)&&(((References)node).getChilds().size() > 0)) {
			res = false;
		} else if((node instanceof Controllers)&&(((Controllers)node).getChilds().size() > 0)) {
			res = false;
		} 
		return res;
	}

	public void valueForPathChanged(final TreePath path, final Object newValue) {

	}

	public int getIndexOfChild(final Object parent, final Object child) {
		int res = 0;
		if(parent == this.getRoot()) {
			if(child instanceof Components) {
				res = 0;
			} else if(child instanceof Services) {
				res = 1;
			} else if(child instanceof References) {
				res = 2;
			} else if(child instanceof Controllers) {
				res = 3;
			} 
		} else if(parent instanceof ComponentG) {
			if(child instanceof Components) {
				res = 0;
			} else if(child instanceof Services) {
				res = 1;
			} else if(child instanceof References) {
				res = 2;
			} else if(child instanceof Controllers) {
				res = 3;
			} 
		} else if(parent instanceof Components) {
			res = ((Components)parent).getChilds().indexOf(child);
		} else if(parent instanceof Services) {
			res = ((Services)parent).getChilds().indexOf(child);
		} else if(parent instanceof References) {
			res = ((References)parent).getChilds().indexOf(child);
		} else if(parent instanceof Controllers) {
			res = ((Controllers)parent).getChilds().indexOf(child);
		} 
		return res;
	}

	@SuppressWarnings("unchecked")
	public void addTreeModelListener(final TreeModelListener l) {
		this.treeModelListeners.add(l);
	}

	public void removeTreeModelListener(final TreeModelListener l) {
		this.treeModelListeners.remove(l);
	}

	public class Components {

		private List<ComponentG> childs;

		public Components(List<ComponentG> childs) {
			this.childs = childs;
		}

		public List<ComponentG> getChilds() {
			return childs;
		}

		public String toString() {
			return "Child components";
		}
	}

	public class Services {

		private List<ServiceG> childs;

		public Services(List<ServiceG> childs) {
			this.childs = childs;
		}

		public List<ServiceG> getChilds() {
			return childs;
		}

		public String toString() {
			return "Services";
		}
	}

	public class References {

		private List<ReferenceG> childs;

		public References(List<ReferenceG> childs) {
			this.childs = childs;
		}

		public List<ReferenceG> getChilds() {
			return childs;
		}

		public String toString() {
			return "References";
		}
	}

	public class Controllers {

		private List<ControllerG> childs;

		public Controllers(List<ControllerG> childs) {
			this.childs = childs;
		}

		public List<ControllerG> getChilds() {
			return childs;
		}

		public String toString() {
			return "Controllers";
		}
	}


}
