package com.ebmwebsourcing.easyesb.ws.bus;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;

import javax.xml.parsers.ParserConfigurationException;

import org.jdom.JDOMException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;

public class BusThread extends Thread{

	private String address;

	static  private int delay;

	private final static SOAPSender sender = new SOAPSender();

	private Document notif;

	private boolean stop;

	public BusThread(String address, int delay) {

		this.stop = false;

		this.address = address;

		BusThread.delay = delay;

		initNotif();
	}

	private void initNotif() {

		File notifFile;
		try {
			
		
			this.notif = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(Thread.currentThread().getContextClassLoader().getResource("notify.xml").openStream());
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	
	public static void setDelay(int d){
		BusThread.delay = d;
	}
	
	@Override
	public void run() {
		try {
			while(!stop){
				System.out.println("Sending notification to "+this.address+"\n"+XMLPrettyPrinter.prettyPrint(notif));
				sender.sendSoapRequest(SOAPSender.createSOAPMessageRequest(notif), this.address, null);
				Thread.sleep(delay*1000);
			}
		} catch (SOAPException e) {
			e.printStackTrace();
		} catch (InterruptedException e) {
			e.printStackTrace();
		} catch (JDOMException e) {
			e.printStackTrace();
		}
	}

	public void stopThread(){
		this.stop = true;
	}
}
