/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.ws.fireman.test;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.DefaultFramework;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsaddressing10.api.element.Address;
import com.ebmwebsourcing.wsaddressing10.api.element.ReferenceParameters;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.implementor.WsnbModelFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.WsnbModelFactoryImpl;
import java.net.URI;
import javax.xml.namespace.QName;
import org.soceda.crisis.v1.deliver_iodine.fireman.CardiacRythm;
import org.soceda.crisis.v1.deliver_iodine.fireman.ObjectFactory;
import org.w3c.dom.Document;

public class NotifierThread
extends Thread {
    private Document payload;
    private String producerAddress;
    private String consumerAddress;
    private QName topicUsed;
    private String dialect;
    private SOAPSender soapSender = new SOAPSender();

    public NotifierThread(String producerAddress, String consumerAddress, QName topicUsed, String dialect, Document payload) {
        this.producerAddress = producerAddress;
        this.consumerAddress = consumerAddress;
        this.topicUsed = topicUsed;
        this.dialect = dialect;
        this.payload = payload;
    }

    @Override
    public void run() {
        try {
            CardiacRythm cr = null;
            if (this.payload == null) {
                cr = new CardiacRythm();
                cr.setValue(90);
                this.payload = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)cr);
            }
            for (int cpt = 0; cpt < 2; ++cpt) {
                try {
                    if (cr != null) {
                        cr.setValue(cr.getValue() + 1);
                    }
                    this.payload = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)cr);
                    Notify notify = NotifierThread.createNotification(this.producerAddress, this.consumerAddress, this.topicUsed, this.dialect, this.payload);
                    Document request = RefinedWsnbFactory.getInstance((WsnbModelFactory)new WsnbModelFactoryImpl()).getWsnbWriter().writeNotifyAsDOM(notify);
                    System.out.println("request notify: \n" + XMLPrettyPrinter.prettyPrint((Document)request));
                    this.soapSender.sendSoapRequest(SOAPSender.createSOAPMessageRequest((Document)request), this.consumerAddress, null);
                    System.out.println("Notification sended to " + this.consumerAddress);
                    Thread.sleep(5000L);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Notify createNotification(String producerAddress, String endpointAddress, QName topicUsed, String dialect, Document notifPayload) throws Exception {
        Address address;
        Notify notifyPayload = null;
        NotificationMessageHolderType.Message mess = null;
        mess = notifPayload != null ? RefinedWsnbFactory.getInstance().createNotificationMessageHolderTypeMessage(notifPayload.getDocumentElement()) : RefinedWsnbFactory.getInstance().createNotificationMessageHolderTypeMessage(null);
        NotificationMessageHolderType msg = RefinedWsnbFactory.getInstance().createNotificationMessageHolderType(mess);
        notifyPayload = RefinedWsnbFactory.getInstance().createNotify(msg);
        if (topicUsed != null) {
            TopicExpressionType notifyTopicExpr = NotifierThread.createTopicExpression(topicUsed, dialect);
            msg.setTopic(notifyTopicExpr);
        }
        if (endpointAddress != null) {
            EndpointReferenceType registrationRef = (EndpointReferenceType)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(EndpointReferenceType.class);
            address = (Address)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(Address.class);
            address.setValue(URI.create(endpointAddress));
            registrationRef.setAddress(address);
            ReferenceParameters ref = (ReferenceParameters)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(ReferenceParameters.class);
            registrationRef.setReferenceParameters(ref);
            msg.setSubscriptionReference(registrationRef);
        }
        EndpointReferenceType producerRef = (EndpointReferenceType)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(EndpointReferenceType.class);
        address = (Address)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(Address.class);
        address.setValue(URI.create(producerAddress));
        producerRef.setAddress(address);
        msg.setProducerReference(producerRef);
        return notifyPayload;
    }

    public static TopicExpressionType createTopicExpression(QName topicUsed, String dialect) throws Exception {
        TopicExpressionType notifyTopicExpr = null;
        notifyTopicExpr = RefinedWsnbFactory.getInstance().createTopicExpressionType(URI.create(dialect));
        if (topicUsed.getPrefix() == null) {
            throw new Exception("prefix of topicUsed cannot be null");
        }
        notifyTopicExpr.addTopicNamespace(topicUsed.getPrefix(), URI.create(topicUsed.getNamespaceURI()));
        notifyTopicExpr.setContent(topicUsed.getPrefix() + ":" + topicUsed.getLocalPart());
        return notifyTopicExpr;
    }

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }
}

