/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.ws.fireman.test;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easyesb.ws.fireman.test.NotifierThread;
import com.ebmwebsourcing.wsn.t_1_extension.EJaxbConcreteTopicExpressionWithQName;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.petalslink.wsn.service.wsnproducer.NotificationProducer;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbGetCurrentMessage;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbGetCurrentMessageResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.MultipleTopicsSpecifiedFault;
import org.oasis_open.docs.wsn.bw_2.NoCurrentMessageOnTopicFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.w3c.dom.Document;

@WebService(serviceName="FiremanEventProducer", portName="FiremanSOAPEventProducer", targetNamespace="http://www.soceda.org/crisis/v1/deliver_iodine/Fireman/", wsdlLocation="crisis/v1/deliver_iodine/Fireman.wsdl", endpointInterface="com.petalslink.wsn.service.wsnproducer.NotificationProducer")
public class NotificationProducerImpl
implements NotificationProducer {
    private static final Logger LOG = Logger.getLogger(NotificationProducerImpl.class.getName());
    private boolean notifier = false;

    @Override
    public EJaxbGetCurrentMessageResponse getCurrentMessage(EJaxbGetCurrentMessage getCurrentMessageRequest) throws TopicNotSupportedFault, InvalidTopicExpressionFault, ResourceUnknownFault, TopicExpressionDialectUnknownFault, NoCurrentMessageOnTopicFault, MultipleTopicsSpecifiedFault {
        LOG.info("Executing operation getCurrentMessage");
        System.out.println(getCurrentMessageRequest);
        try {
            EJaxbGetCurrentMessageResponse _return = null;
            return _return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    @Override
    public EJaxbUnsubscribeResponse unsubscribe(EJaxbUnsubscribe unsubscribeRequest) throws ResourceUnknownFault, UnableToDestroySubscriptionFault {
        LOG.info("Executing operation unsubscribe");
        System.out.println(unsubscribeRequest);
        try {
            EJaxbUnsubscribeResponse _return = null;
            return _return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    @Override
    public EJaxbSubscribeResponse subscribe(EJaxbSubscribe subscribeRequest) throws NotifyMessageNotSupportedFault, TopicNotSupportedFault, InvalidFilterFault, InvalidTopicExpressionFault, ResourceUnknownFault, TopicExpressionDialectUnknownFault, UnrecognizedPolicyRequestFault, SubscribeCreationFailedFault, InvalidMessageContentExpressionFault, UnsupportedPolicyRequestFault, UnacceptableInitialTerminationTimeFault, InvalidProducerPropertiesExpressionFault {
        LOG.info("Executing operation subscribe");
        System.out.println(subscribeRequest);
        try {
            Document doc = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)subscribeRequest);
            Subscribe subscribe = Wsnb4ServUtils.getWsnbReader().readSubscribe(doc);
            List<QName> topics = this.findTopics(subscribe);
            QName topic = null;
            if (topics != null && topics.size() > 0) {
                topic = topics.get(0);
            }
            String address = subscribe.getConsumerReference().getAddress().getValue().toString();
            if (this.isNotifier()) {
                NotifierThread notifier = new NotifierThread(this.getClass().getAnnotation(WebService.class).portName(), address, topic, "http://www.w3.org/TR/1999/REC-xpath-19991116", null);
                notifier.start();
            }
            EJaxbSubscribeResponse _return = new EJaxbSubscribeResponse();
            return _return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private List<QName> findTopics(Subscribe subscribe) {
        ArrayList<QName> topics = new ArrayList<QName>();
        for (TopicExpressionType topicItem : subscribe.getFilter().getTopicExpressions()) {
            QName topic = null;
            if (topicItem.getContent() instanceof JAXBElement) {
                JAXBElement elmt = (JAXBElement)topicItem.getContent();
                if (elmt.getValue() instanceof QName) {
                    topic = (QName)elmt.getValue();
                }
            } else if (topicItem.getContent() instanceof EJaxbConcreteTopicExpressionWithQName) {
                EJaxbConcreteTopicExpressionWithQName msgTopic = (EJaxbConcreteTopicExpressionWithQName)topicItem.getContent();
                topic = new QName(msgTopic.getConcreteTopicExpression());
            }
            topics.add(topic);
        }
        return topics;
    }

    @Override
    public EJaxbGetResourcePropertyResponse getResourceProperty(QName getResourcePropertyRequest) throws ResourceUnknownFault, InvalidResourcePropertyQNameFault, ResourceUnavailableFault {
        LOG.info("Executing operation getResourceProperty");
        System.out.println(getResourcePropertyRequest);
        try {
            EJaxbGetResourcePropertyResponse _return = new EJaxbGetResourcePropertyResponse();
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(Thread.currentThread().getContextClassLoader().getResource("crisis/v1/deliver_iodine/FiremanTopicSet.xml").openStream());
            _return.getAny().add(doc.getDocumentElement());
            return _return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public void setNotifier(boolean notifier) {
        this.notifier = notifier;
    }

    public boolean isNotifier() {
        return this.notifier;
    }
}

