package com.ebmwebsourcing.easyesb.ws.fireman.test;

import java.net.URI;

import javax.xml.namespace.QName;

import org.soceda.crisis.v1.deliver_iodine.fireman.CardiacRythm;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.DefaultFramework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsaddressing10.api.element.Address;
import com.ebmwebsourcing.wsaddressing10.api.element.ReferenceParameters;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType.Message;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.WsnbModelFactoryImpl;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;

public class NotifierThread extends Thread {

	private Document payload;
	private String producerAddress;
	private String consumerAddress;
	private QName topicUsed;
	private String dialect;

	private SOAPSender soapSender = new SOAPSender();

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(org.soceda.crisis.v1.deliver_iodine.fireman.ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}

	public NotifierThread(String producerAddress, String consumerAddress, QName topicUsed, String dialect, Document payload) {
		this.producerAddress = producerAddress;
		this.consumerAddress = consumerAddress;
		this.topicUsed = topicUsed;
		this.dialect = dialect;
		this.payload = payload;
	}


	@Override
	public void run() {
		try {
			CardiacRythm cr = null;
			if(payload == null) {
				cr = new CardiacRythm();
				cr.setValue(90);
				payload = SOAJAXBContext.getInstance().unmarshallAnyElement(cr);
			}
			int cpt = 0;
			while(cpt < 2) {
				try {
					if(cr != null) {
						cr.setValue(cr.getValue()+1);
					}
					payload = SOAJAXBContext.getInstance().unmarshallAnyElement(cr);

					Notify notify = NotifierThread.createNotification(producerAddress, consumerAddress, topicUsed, dialect, payload);
					Document request = RefinedWsnbFactory.getInstance(new WsnbModelFactoryImpl()).getWsnbWriter().writeNotifyAsDOM(notify);
					System.out.println("request notify: \n" + XMLPrettyPrinter.prettyPrint(request));
					this.soapSender.sendSoapRequest(SOAPSender.createSOAPMessageRequest(request), consumerAddress, null);
					System.out.println("Notification sended to " + consumerAddress);

					Thread.sleep(5000);
				} catch (Exception e) {
					// do nothing
					e.printStackTrace();
				}
				cpt++;
			}
		} catch (Exception e) {
			// do nothing
			e.printStackTrace();
		}
	}


	public static Notify createNotification(String producerAddress, String endpointAddress, 
			QName topicUsed, String dialect, Document notifPayload) throws Exception {
		Notify notifyPayload = null;

		Message mess = null;
		if(notifPayload != null) {
			mess = RefinedWsnbFactory.getInstance()
					.createNotificationMessageHolderTypeMessage(notifPayload.getDocumentElement());
		} else {
			mess = RefinedWsnbFactory.getInstance()
					.createNotificationMessageHolderTypeMessage(null);
		}
		NotificationMessageHolderType msg = RefinedWsnbFactory
				.getInstance().createNotificationMessageHolderType(mess);
		notifyPayload = RefinedWsnbFactory.getInstance().createNotify(msg);

		if(topicUsed != null) {
			final TopicExpressionType notifyTopicExpr = createTopicExpression(topicUsed, dialect);
			msg.setTopic(notifyTopicExpr);
		}

		if(endpointAddress != null) {
			final EndpointReferenceType registrationRef = SOAUtil.getInstance().getXmlContext(DefaultFramework.getInstance()).getXmlObjectFactory().create(EndpointReferenceType.class);
			Address address = SOAUtil.getInstance().getXmlContext(DefaultFramework.getInstance()).getXmlObjectFactory().create(Address.class);
			address.setValue(URI.create(endpointAddress));
			registrationRef.setAddress(address);

			final ReferenceParameters ref = SOAUtil.getInstance().getXmlContext(DefaultFramework.getInstance()).getXmlObjectFactory().create(ReferenceParameters.class);
			registrationRef.setReferenceParameters(ref);

			msg.setSubscriptionReference(registrationRef);
		}
		final EndpointReferenceType producerRef = SOAUtil.getInstance().getXmlContext(DefaultFramework.getInstance()).getXmlObjectFactory().create(EndpointReferenceType.class);
		Address address = SOAUtil.getInstance().getXmlContext(DefaultFramework.getInstance()).getXmlObjectFactory().create(Address.class);
		address.setValue(URI.create(producerAddress));
		producerRef.setAddress(address);
		msg.setProducerReference(producerRef);



		return notifyPayload;
	}

	public static TopicExpressionType createTopicExpression(QName topicUsed, String dialect) throws Exception {
		TopicExpressionType notifyTopicExpr =  WSNHelper.createSimpleTopicExpression(topicUsed, dialect);

		return notifyTopicExpr;
	}
}
