/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.launcher.tasks;

import com.ebmwebsourcing.easyesb.launcher.tasks.Task;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InfoTask
extends Task {
    private Node node = null;

    public InfoTask(Node node) {
        this.node = node;
        this.setShortcut("i");
        this.setName("info");
        this.setDescription("Display the local container information");
    }

    @Override
    public int doProcess(List<String> args) {
        block13: {
            try {
                System.out.println("Infos");
                if (this.node != null) {
                    ExternalServer server2;
                    ArrayList<String> components = new ArrayList<String>();
                    ArrayList<String> services = new ArrayList<String>();
                    ArrayList<String> providerEndpoints = new ArrayList<String>();
                    ArrayList<String> clientProxyEndpoints = new ArrayList<String>();
                    for (Endpoint ep : ((RegistryEndpointBehaviour)this.node.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoints()) {
                        Object e = ep.getComponent().getFcInterface("service");
                        if (e instanceof Component) {
                            components.add(ep.getQName().toString());
                            continue;
                        }
                        if (e instanceof Service) {
                            services.add(ep.getQName().toString());
                            continue;
                        }
                        if (e instanceof ProviderEndpoint) {
                            providerEndpoints.add(ep.getQName().toString());
                            continue;
                        }
                        if (!(e instanceof ClientEndpoint)) continue;
                        clientProxyEndpoints.add(ep.getQName().toString());
                    }
                    services.add(((Service)this.node.getRegistryEndpoint().getParent()).getQName().toString());
                    providerEndpoints.add(this.node.getRegistryEndpoint().getQName().toString());
                    System.out.println("\n\n\nLocal composition of node: " + this.node.getQName());
                    System.out.println("--------------------------\n");
                    int port = -1;
                    Iterator i$ = ((NodeBehaviour)this.node.findBehaviour(NodeBehaviour.class)).getExternalServers().iterator();
                    while (i$.hasNext() && (port = (server2 = (ExternalServer)i$.next()).getPort()) == -1) {
                    }
                    System.out.println("External administration service available at: \n\thttp://" + this.node.getModel().getBasicNodeInformations().getHost() + ":" + port + "/services/adminExternalEndpoint?wsdl");
                    System.out.println("External resources service available at: \n\thttp://" + this.node.getModel().getBasicNodeInformations().getHost() + ":" + port + "/services/resourcesExternalEndpoint?wsdl");
                    System.out.println("\n\nListeners:\n");
                    for (ExternalServer server2 : ((NodeBehaviour)this.node.findBehaviour(NodeBehaviour.class)).getExternalServers()) {
                        System.out.println("\t- " + server2.getName());
                    }
                    System.out.println("\n\nComponents:\n");
                    for (String comp : components) {
                        System.out.println("\t- " + comp);
                    }
                    System.out.println("\n\nServices:\n");
                    for (String s : services) {
                        System.out.println("\t- " + s);
                    }
                    System.out.println("\n\nProvider Endpoints:\n");
                    for (String pep : providerEndpoints) {
                        System.out.println("\t- " + pep);
                    }
                    System.out.println("\n\nClient Proxy Endpoints:\n");
                    for (String cep : clientProxyEndpoints) {
                        System.out.println("\t- " + cep);
                    }
                    break block13;
                }
                throw new ESBException("node cannot be null");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return 1;
    }
}

