/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.soa.impl.transport;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.XmlObjectValidationException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.io.ClassUtil;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;
import com.ebmwebsourcing.easyesb.exchange10.api.util.Util;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.transport.TransportersManager;
import com.ebmwebsourcing.easyesb.soa.api.transport.WakeUpKey;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa10.api.element.SourceNodeInformations;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportContext;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyesb.transporter.api.transport.Transporter;
import com.ebmwebsourcing.easyesb.transporter.impl.soap.SOAPTransporterImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;
import org.w3c.dom.Document;

@Scope(value="COMPOSITE")
@Service(value={TransportersManager.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyCompositeWithContent"})
public class TransportersManagerImpl
extends SCAComponentImpl
implements TransportersManager {
    private static final long serialVersionUID = 1L;
    private QName name;
    private List<Component> transporters = new ArrayList<Component>();
    private Map<UUID, WakeUpKey> stub2awake = new HashMap<UUID, WakeUpKey>();
    private Node node = null;

    public <T extends Transporter> T createTransporter(String name, Class<T> clazz) throws ESBException {
        Transporter transporter = null;
        try {
            Component transporterComponent = SCAHelper.getSCAHelper().createNewComponent(clazz.getName(), null);
            SCAHelper.getSCAHelper().startComponent(transporterComponent);
            if (name != null) {
                SCAHelper.getSCAHelper().changeName(transporterComponent, name.toString());
            }
            transporter = (Transporter)transporterComponent.getFcInterface("service");
            SCAHelper.getSCAHelper().addComponent(transporterComponent, this.getComponent(), null);
            this.transporters.add(transporterComponent);
        }
        catch (NoSuchInterfaceException e) {
            throw new ESBException((Throwable)e);
        }
        catch (SCAException e) {
            throw new ESBException((Throwable)e);
        }
        return (T)transporter;
    }

    private Transporter findTransporter() throws TransportException {
        Transporter protocol = null;
        try {
            if (this.transporters == null || this.transporters.size() == 0) {
                throw new TransportException("Impossible to find transporter");
            }
            protocol = (Transporter)((SCAContentController)this.transporters.get(0).getFcInterface("/sca-content-controller")).getFcContent();
        }
        catch (NoSuchInterfaceException e) {
            throw new TransportException((Throwable)e);
        }
        catch (ContentInstantiationException e) {
            throw new TransportException((Throwable)e);
        }
        return protocol;
    }

    public void setQName(QName name) {
        this.name = name;
    }

    public QName getQName() {
        return this.name;
    }

    public synchronized Exchange pull(QName providerEndpointName, QName nodeEndpointName) throws TransportException {
        Exchange res = null;
        Transporter protocol = null;
        if (providerEndpointName == null) {
            throw new TransportException("provider name cannot be null");
        }
        if (nodeEndpointName == null) {
            throw new TransportException("node name cannot be null");
        }
        protocol = this.findTransporter();
        res = protocol.pull(providerEndpointName, nodeEndpointName);
        return res;
    }

    public void push(Exchange exchange, QName destinationNodeName) throws TransportException {
        if (destinationNodeName == null) {
            throw new TransportException("destination name cannot be null");
        }
        if (exchange == null) {
            throw new TransportException("exchange cannot be null");
        }
        QName destination = exchange.getDestination();
        if (exchange.getStatus().equals((Object)StatusType.DONE) || exchange.getStatus().equals((Object)StatusType.FAULT)) {
            destination = exchange.getSource();
        }
        Transporter protocol = this.findTransporter();
        SourceNodeInformations sourceNodeInfos = null;
        Document sourceNodeDoc = null;
        if (exchange.getMessageIn().getHeader() != null) {
            sourceNodeDoc = exchange.getMessageIn().getHeader().getProperty(new QName("http://com.petalslink.easyesb/soa/model/datatype/1.0", "sourceNodeInformations"));
        }
        if (sourceNodeDoc != null) {
            try {
                sourceNodeInfos = (SourceNodeInformations)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasyESBFramework.getInstance()).get()).readFragment(Util.convertDocumentToInputStream((Document)sourceNodeDoc), SourceNodeInformations.class);
            }
            catch (XmlObjectValidationException e) {
                throw new TransportException((Throwable)e);
            }
            catch (XmlObjectReadException e) {
                throw new TransportException((Throwable)e);
            }
        }
        if (protocol instanceof SOAPTransporterImpl && sourceNodeInfos != null) {
            ((SOAPTransporterImpl)protocol).getListOfTransporters().put(sourceNodeInfos.getNodeName(), MessageUtil.getInstance().getSOAPTransporterAddress(sourceNodeInfos.getHost(), sourceNodeInfos.getPort()));
        }
        protocol.push(exchange, destinationNodeName);
    }

    public Map<UUID, WakeUpKey> getStub2awake() {
        return this.stub2awake;
    }

    public TransportContext getContext() {
        return null;
    }

    public void setContext(TransportContext arg0) {
        throw new UnsupportedOperationException();
    }

    public void stop() throws TransportException {
        try {
            for (Component transporter : this.transporters) {
                Transporter protocol = (Transporter)transporter.getFcInterface("service");
                protocol.stop();
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new TransportException((Throwable)e);
        }
    }

    public void start() throws TransportException {
        try {
            for (Component transporter : this.transporters) {
                Transporter protocol = (Transporter)transporter.getFcInterface("service");
                protocol.start();
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new TransportException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isStopped() {
        boolean res = false;
        try {
            Component c;
            Iterator<Component> iterator = this.transporters.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (((Transporter)(c = iterator.next()).getFcInterface("service")).isStopped());
            return false;
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
            return false;
        }
    }

    public <T extends Transporter> T getTransporter(Class<T> clazz) {
        Transporter transporter = null;
        try {
            for (Component transporterC : this.transporters) {
                Transporter protocol = (Transporter)((SCAContentController)transporterC.getFcInterface("/sca-content-controller")).getFcContent();
                if (!ClassUtil.isClassExtendOfClass2found(protocol.getClass(), clazz)) continue;
                transporter = protocol;
                break;
            }
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
        }
        catch (ContentInstantiationException e) {
            e.printStackTrace();
        }
        return (T)transporter;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }
}

