/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.impl.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryService;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.transport.listener.ListenersManagerImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.BehavioursList;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.ProviderEndpointsGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.type.BusinessServiceType;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ServiceType;
import com.ebmwebsourcing.easyesb.soa10.api.type.TechnicalServiceType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbServiceType;
import easyesb.ebmwebsourcing.com.soa.model.registry.RegistryFault_Exception;
import easyesb.ebmwebsourcing.com.soa.model.service.GetProviderEndpoints;
import easyesb.ebmwebsourcing.com.soa.model.service.GetProviderEndpointsResponse;


public class ServiceBehaviourImpl extends AbstractEndpointBehaviourImpl implements ServiceBehaviour {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(ServiceBehaviourImpl.class.getName());


	private List<ProviderEndpoint<? extends ProviderEndpointType>> endpoints = new ArrayList<ProviderEndpoint<? extends ProviderEndpointType>>();


	public ServiceBehaviourImpl(Service<? extends ServiceType> ep) {
		super(ep);
		
		try {
			Description desc = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasyESBFramework.getInstance()).get().readDocument(Thread.currentThread().getContextClassLoader().getResource(DESCRIPTION_URL), Definitions.class));
			this.setBinding(desc.getBindings().iterator().next());
		} catch (XmlObjectReadException e) {
			e.printStackTrace();
			throw new RuntimeException();
		}
	}


	public void execute(Exchange exchange) throws TransportException {
		try {
			log.finest("Service BEHAVIOUR FOUND: " + exchange.getOperation());
			log.finest("Service BEHAVIOUR FOUND: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageIn().printMessage()));

			if (QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("getProviderEndpoints") &&
					QName.valueOf(exchange.getOperation()).getNamespaceURI()
					.equals("http://com.ebmwebsourcing.easyesb/soa/model/service")) {
				log.finest("getProviderEndpoints");

				GetProviderEndpoints request = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetProviderEndpoints.class);
				GetProviderEndpointsResponse response = this.getProviderEndpoints(request);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);
				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} 
		} catch (SOAException e) {
			log.severe("ESB Exception: " + e.getMessage());
			throw new TransportException(e);
		} 
	}


	@SuppressWarnings("unchecked")
	public <PE extends ProviderEndpoint<? extends ProviderEndpointType>> PE createProviderEndpoint(String name, Class<PE> endpointClass, EndpointInitialContext initialEndpointContext) throws ESBException {
		PE providerEndpoint = null;
		try {

			// create model			
			ProviderEndpointType model = null; 
			if(ProviderProxyEndpoint.class.isAssignableFrom(endpointClass)) {
				model = (ProviderEndpointType) SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(com.ebmwebsourcing.easyesb.soa10.api.element.ProviderProxyEndpoint.class);
			} else {
				model = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(com.ebmwebsourcing.easyesb.soa10.api.element.ProviderEndpoint.class);
			}
			//model.setBehaviour(endpointClass.getName());
			model.setType(endpointClass.getName());
			model.setEndpointInitialContext(initialEndpointContext);
			model.setBehavioursList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(BehavioursList.class));
			model.setName(new QName(this.endpoint.getQName().getNamespaceURI(), name));
			model.setNode(this.getNodeQName());
			model.setBasicNodeInformations(this.endpoint.getModel().getBasicNodeInformations());
			model.setService(this.endpoint.getQName());


			RegistryService<?> registryService = ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getRegistryService();
			if(registryService != null) {

				// add service in registry
				boolean res = ((RegistryEndpointBehaviour)((RegistryServiceBehaviour)((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getRegistryService().findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addEndpoint((EJaxbEndpointType) model.getModelObject());

				if(res) {
					// get component
					providerEndpoint = (PE) ((RegistryEndpointBehaviour) ((RegistryServiceBehaviour)((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getRegistryService().findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(model.getName());
				}
			} else {
				Map<String, Object> context = new HashMap<String, Object>();
				context.put("model", model);
				context.put("parent", this.getEndpoint());

				// create component in composite
				org.objectweb.fractal.api.Component providerEndpointComponent = SCAHelper.getSCAHelper().createNewComponent(endpointClass.getName(), context);
				SCAHelper.getSCAHelper().addComponent(providerEndpointComponent, this.getEndpoint().getComponent(), null);
				SCAHelper.getSCAHelper().startComponent(providerEndpointComponent);

				if(name != null) {
					SCAHelper.getSCAHelper().changeName(providerEndpointComponent, new QName(this.endpoint.getQName().getNamespaceURI(), name).toString());
				}

				providerEndpoint = (PE) providerEndpointComponent.getFcInterface("service");
				providerEndpoint.setNode((Node) this.getEndpoint().getNode());
				providerEndpoint.setServiceProvider((Service<? extends ServiceType>) this.getEndpoint());
				providerEndpoint.init();

				// create listener or add endpoint in listener node
				if((providerEndpoint.getModel().getEndpointInitialContext() != null)&&(providerEndpoint.getModel().getEndpointInitialContext().getNumberOfThreads() > 0)) {
					Map<QName, Endpoint<? extends EndpointType>> endpoints = Collections.synchronizedMap(new HashMap<QName, Endpoint<? extends EndpointType>>());
					endpoints.put(providerEndpoint.getQName(), providerEndpoint);
					providerEndpoint.setListenersManager(new ListenersManagerImpl(providerEndpoint.getModel().getEndpointInitialContext().getNumberOfThreads(), endpoints));
				} else {
					this.getEndpoint().getNode().getListenedEndpoints().put(providerEndpoint.getQName(), providerEndpoint);
				}

				if(this.endpoint.getModel() instanceof BusinessServiceType) {
					BusinessServiceType bs = (BusinessServiceType) this.endpoint.getModel();
					if(bs.getProviderEndpointsGroupList() == null) {
						bs.setProviderEndpointsGroupList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(ProviderEndpointsGroupList.class));
					}
					bs.getProviderEndpointsGroupList().addProviderEndpoint(model);
				} else {
					TechnicalServiceType ts = (TechnicalServiceType) this.endpoint.getModel();
					if(ts.getProviderEndpointsGroupList() == null) {
						ts.setProviderEndpointsGroupList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(ProviderEndpointsGroupList.class));
					}
					ts.getProviderEndpointsGroupList().addProviderEndpoint(model);
				}
			}

		} catch (SecurityException e) {
			throw new ESBException(e);
		} catch (IllegalArgumentException e) {
			throw new ESBException(e);
		} catch (RegistryFault_Exception e) {
			throw new ESBException(e);
		} catch (SCAException e) {
			throw new ESBException(e);
		} catch (NoSuchInterfaceException e) {
			throw new ESBException(e);
		}
		log.fine("providerEndpoint " + name + " created and started");
		return providerEndpoint;
	}

	public List<ProviderEndpoint<? extends ProviderEndpointType>> getProviderEndpoints() {
		return this.endpoints;
	}

	public ProviderEndpoint<? extends ProviderEndpointType> getProviderEndpoint(
			QName name) {
		ProviderEndpoint<? extends ProviderEndpointType> res = null;
		for(ProviderEndpoint<? extends ProviderEndpointType> p : this.endpoints) {
			if(p.getQName().equals(name)) {
				res = p;
				break;
			}
		}
		return res;
	}

	public ProviderEndpoint<? extends ProviderEndpointType> removeProviderEndpoint(
			ProviderEndpoint<? extends ProviderEndpointType> p) throws ESBException {
		ProviderEndpoint<? extends ProviderEndpointType> res = null;
		res = this.getProviderEndpoint(p.getQName());
		if(res != null) {
			// delete model
			if(this.endpoint.getModel() instanceof BusinessServiceType) {
				BusinessServiceType bs = (BusinessServiceType) this.endpoint.getModel();
				bs.getProviderEndpointsGroupList().removeProviderEndpoint((com.ebmwebsourcing.easyesb.soa10.api.element.ProviderEndpoint) res.getModel());
			} else {
				TechnicalServiceType ts = (TechnicalServiceType) this.endpoint.getModel();
				ts.getProviderEndpointsGroupList().removeProviderEndpoint((com.ebmwebsourcing.easyesb.soa10.api.element.ProviderEndpoint) res.getModel());
			}

			// delete in list
			this.endpoints.remove(res);

			// delete in registry
			((RegistryEndpointBehaviour)this.endpoint.getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).removeLocalEndpoint(res);

		}
		return res;
	}
	

	@Override
	public GetProviderEndpointsResponse getProviderEndpoints(
			GetProviderEndpoints parameters) {
		GetProviderEndpointsResponse res = new GetProviderEndpointsResponse();
		res.setProviderEndpointsGroupList(((EJaxbServiceType)((ServiceType)this.endpoint.getModel()).getModelObject()).getProviderEndpointsGroupList());
		return res;
	}












}
