/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.soa.impl.endpoint;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.xml.resolver.ClasspathURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.DefaultURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.URIMultipleResolvers;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationConsumerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.ProviderProxyBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.EndpointInitializationInterceptor;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.transport.Skeleton;
import com.ebmwebsourcing.easyesb.soa.api.transport.TransportersManager;
import com.ebmwebsourcing.easyesb.soa.api.transport.listener.ListenersManager;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.resolver.EasyESBInternalURIResolver;
import com.ebmwebsourcing.easyesb.soa.impl.transport.SkeletonImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.NodeType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Import;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;
import com.ebmwebsourcing.soapbinding11.api.element.Address;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.URIResolver;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.osoa.sca.annotations.Property;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;

@Scope(value="COMPOSITE")
@Service(value={Endpoint.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public abstract class AbstractEndpointImpl<M extends EndpointType>
extends SCAComponentImpl
implements Endpoint<M> {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(AbstractEndpointImpl.class.getName());
    private Node<? extends NodeType> node;
    protected Description description;
    private ListenersManager listenersManager = null;
    @Property(name="model", required=true)
    protected M model = null;
    @Property(name="behaviours", required=true)
    private List<EndpointBehaviour> behaviours = null;
    @Property(name="parent", required=true)
    protected SOAElement<?> parent = null;
    private Skeleton skeleton = null;
    protected List<EndpointInitializationInterceptor> initializationsInterceptor = new ArrayList<EndpointInitializationInterceptor>();

    public AbstractEndpointImpl() {
        this.skeleton = new SkeletonImpl(this);
    }

    public AbstractEndpointImpl(M model, SOAElement<?> parent) throws ESBException {
        assert (model != null);
        this.model = model;
        this.skeleton = new SkeletonImpl(this);
        if (model == null) {
            throw new ESBException("the model cannot be null!!!");
        }
        if (this.model.getName() == null) {
            throw new ESBException("the endpoint name cannot be null!!!");
        }
        this.model.setType(((Object)((Object)this)).getClass().getName());
        this.parent = parent;
    }

    public SOAElement<?> getParent() {
        return this.parent;
    }

    public void init() throws ESBException {
        try {
            this.behaviours = new ArrayList<EndpointBehaviour>();
            Class<EndpointBehaviour>[] classArray = this.getBehaviourClasses();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<EndpointBehaviour> behaviourClass = classArray[n2];
                EndpointBehaviour behaviour = this.createBehaviourFormClass(behaviourClass);
                this.behaviours.add(behaviour);
                ++n2;
            }
            this.description = this.createDescriptionFromBehaviours();
            this.createEndpointInitializationInterceptorFromContext();
            this.createEndpointInitializationInterceptorFromConfiguration();
            for (EndpointInitializationInterceptor eii : this.initializationsInterceptor) {
                eii.processingCreation();
            }
        }
        catch (ClassNotFoundException e) {
            throw new ESBException((Throwable)e);
        }
    }

    private void createEndpointInitializationInterceptorFromConfiguration() throws ESBException {
        List interceptorClassNames;
        Configuration conf = null;
        if (this.getNode() != null) {
            conf = ((NodeBehaviour)this.getNode().findBehaviour(NodeBehaviour.class)).getConfiguration();
        }
        if (conf != null && (interceptorClassNames = conf.getEndpointInitializationInterceptorClassNames()) != null) {
            for (String interceptorClassName : interceptorClassNames) {
                try {
                    Class<?> interceptorClass = Thread.currentThread().getContextClassLoader().loadClass(interceptorClassName);
                    log.fine("create interceptor: " + interceptorClass);
                    Constructor<?> constructor = interceptorClass.getConstructors()[0];
                    EndpointInitializationInterceptor eii = (EndpointInitializationInterceptor)constructor.newInstance(new Object[]{this});
                    this.initializationsInterceptor.add(eii);
                }
                catch (ClassNotFoundException e) {
                    log.severe("ERROR : " + e.getMessage());
                    e.printStackTrace();
                    throw new ESBException((Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    log.severe("ERROR : " + e.getMessage());
                    e.printStackTrace();
                    throw new ESBException((Throwable)e);
                }
                catch (InstantiationException e) {
                    log.severe("ERROR : " + e.getMessage());
                    e.printStackTrace();
                    throw new ESBException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.severe("ERROR : " + e.getMessage());
                    e.printStackTrace();
                    throw new ESBException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.severe("ERROR : " + e.getMessage());
                    e.printStackTrace();
                    throw new ESBException((Throwable)e);
                }
                catch (SecurityException e) {
                    log.severe("ERROR : " + e.getMessage());
                    e.printStackTrace();
                    throw new ESBException((Throwable)e);
                }
            }
        }
    }

    private void createEndpointInitializationInterceptorFromContext() throws ESBException {
        List<String> interceptorClassNames = null;
        if (this.model.getEndpointInitialContext() != null && this.model.getEndpointInitialContext().getInitializationInterceptors() != null) {
            interceptorClassNames = Arrays.asList(this.model.getEndpointInitialContext().getInitializationInterceptors().getInterceptorClassName());
        }
        if (interceptorClassNames != null) {
            for (String interceptorClassName : interceptorClassNames) {
                try {
                    Class<?> interceptorClass = Thread.currentThread().getContextClassLoader().loadClass(interceptorClassName);
                    log.fine("create interceptor: " + interceptorClass);
                    Constructor<?> constructor = interceptorClass.getConstructors()[0];
                    EndpointInitializationInterceptor eii = (EndpointInitializationInterceptor)constructor.newInstance(new Object[]{this});
                    this.initializationsInterceptor.add(eii);
                }
                catch (ClassNotFoundException e) {
                    log.severe("ERROR : " + e.getMessage());
                    e.printStackTrace();
                    throw new ESBException((Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    log.severe("ERROR : " + e.getMessage());
                    e.printStackTrace();
                    throw new ESBException((Throwable)e);
                }
                catch (InstantiationException e) {
                    log.severe("ERROR : " + e.getMessage());
                    e.printStackTrace();
                    throw new ESBException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.severe("ERROR : " + e.getMessage());
                    e.printStackTrace();
                    throw new ESBException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.severe("ERROR : " + e.getMessage());
                    e.printStackTrace();
                    throw new ESBException((Throwable)e);
                }
                catch (SecurityException e) {
                    log.severe("ERROR : " + e.getMessage());
                    e.printStackTrace();
                    throw new ESBException((Throwable)e);
                }
            }
        }
    }

    public QName getQName() {
        return this.model.getName();
    }

    public void setQName(QName name) {
        this.setName(name.toString());
        this.model.setName(name);
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public Node<? extends NodeType> getNode() {
        return this.node;
    }

    public void accept(Exchange exchange) throws TransportException {
        this.skeleton.accept(exchange);
    }

    public void sendResponseToClient(Exchange exchange) throws TransportException {
        this.skeleton.sendResponseToClient(exchange);
    }

    public boolean getTakeToSendResponseInCharge() {
        return this.skeleton.getTakeToSendResponseInCharge();
    }

    public void setTakeToSendResponseInCharge(boolean takeToSendResponseInCharge) {
        this.skeleton.setTakeToSendResponseInCharge(takeToSendResponseInCharge);
    }

    public TransportersManager getTransportersManager() throws ESBException {
        return this.getNode().getTransportersManager();
    }

    public void setNode(Node<? extends NodeType> node) {
        this.node = node;
        if (this.model != null) {
            this.model.setNode(node.getQName());
            this.model.setBasicNodeInformations(((NodeType)node.getModel()).getBasicNodeInformations());
        }
    }

    public ListenersManager getListenersManager() {
        return this.listenersManager;
    }

    public void setListenersManager(ListenersManager listenersManager) {
        this.listenersManager = listenersManager;
    }

    public M getModel() {
        return this.model;
    }

    public void addEndpointInitializationInterceptor(EndpointInitializationInterceptor i) {
        this.initializationsInterceptor.add(i);
    }

    public EndpointInitializationInterceptor removeEndpointInitializationInterceptor(EndpointInitializationInterceptor i) {
        return this.initializationsInterceptor.remove(i) ? i : null;
    }

    public List<EndpointInitializationInterceptor> getEndpointInitializationInterceptors() {
        return this.initializationsInterceptor;
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description desc) {
        this.description = desc;
    }

    public Class<? extends EndpointBehaviour>[] getBehaviourClasses() throws ClassNotFoundException {
        ArrayList res = new ArrayList();
        String[] stringArray = this.getModel().getBehavioursList().getBehaviours();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            res.add(Class.forName(className));
            ++n2;
        }
        return res.toArray(new Class[res.size()]);
    }

    public void addBehaviourClass(Class<? extends EndpointBehaviour> behaviourClass) throws ESBException {
        if (behaviourClass != null && this.model.getBehavioursList().getBehaviourByName(behaviourClass.getName()) == null) {
            this.model.getBehavioursList().addBehaviour(behaviourClass.getName());
            this.behaviours.add(this.createBehaviourFormClass(behaviourClass));
            this.description = this.createDescriptionFromBehaviours();
        }
    }

    public void removeBehaviourClass(Class<? extends EndpointBehaviour> behaviourClass) throws ESBException {
        this.model.getBehavioursList().removeBehaviour(behaviourClass.getName());
        EndpointBehaviour behaviourToDelete = null;
        for (EndpointBehaviour eb : this.getBehaviours()) {
            if (!behaviourClass.isAssignableFrom(eb.getClass())) continue;
            behaviourToDelete = eb;
        }
        if (behaviourToDelete != null) {
            this.behaviours.remove(behaviourToDelete);
            this.description = this.createDescriptionFromBehaviours();
        }
    }

    public List<EndpointBehaviour> getBehaviours() {
        return this.behaviours;
    }

    private EndpointBehaviour createBehaviourFormClass(Class<? extends EndpointBehaviour> behaviourClass) throws ESBException {
        EndpointBehaviour res = null;
        if (behaviourClass != null) {
            log.fine("create behaviour: " + behaviourClass);
            try {
                Constructor<?> constructor = behaviourClass.getConstructors()[0];
                res = (EndpointBehaviour)constructor.newInstance(new Object[]{this});
            }
            catch (IllegalArgumentException e) {
                log.severe("ERROR : " + e.getMessage());
                e.printStackTrace();
                throw new ESBException((Throwable)e);
            }
            catch (InstantiationException e) {
                log.severe("ERROR : " + e.getMessage());
                e.printStackTrace();
                throw new ESBException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.severe("ERROR : " + e.getMessage());
                e.printStackTrace();
                throw new ESBException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.severe("ERROR : " + e.getMessage());
                e.printStackTrace();
                throw new ESBException((Throwable)e);
            }
            catch (SecurityException e) {
                log.severe("ERROR : " + e.getMessage());
                e.printStackTrace();
                throw new ESBException((Throwable)e);
            }
        }
        return res;
    }

    public <B> B findBehaviour(Class<B> behaviour) {
        EndpointBehaviour res = null;
        if (this.getBehaviours() != null) {
            for (EndpointBehaviour b : this.getBehaviours()) {
                if (!behaviour.isAssignableFrom(b.getClass())) continue;
                res = b;
                break;
            }
        }
        return (B)res;
    }

    public void refreshDescription() throws ESBException {
        this.description = this.createDescriptionFromBehaviours();
    }

    private Description createDescriptionFromBehaviours() throws ESBException {
        Description desc = null;
        if (this instanceof ProviderEndpoint) {
            Definitions def = (Definitions)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Definitions.class);
            QName serviceQName = null;
            if (this instanceof Component) {
                serviceQName = this.getQName();
            } else if (this instanceof com.ebmwebsourcing.easyesb.soa.api.service.Service) {
                serviceQName = this.getQName();
            } else if (this instanceof ProviderEndpoint) {
                if (((ProviderEndpoint)this).getServiceProvider() != null) {
                    serviceQName = ((ProviderEndpoint)this).getServiceProvider().getModel().getName();
                }
                if (serviceQName == null && this.findBehaviour(NotificationConsumerEndpointBehaviour.class) != null) {
                    serviceQName = this.getQName();
                }
            }
            if (serviceQName == null) {
                throw new ESBException("serviceQName cannot be null!!!");
            }
            EasyESBInternalURIResolver resolver = new EasyESBInternalURIResolver();
            SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).setURIResolver((URIResolver)new URIMultipleResolvers(new URIResolver[]{new DefaultURIResolver(), new ClasspathURIResolver(), new EasyESBInternalURIResolver()}));
            def.setTargetNamespace(serviceQName.getNamespaceURI());
            def.setName(String.valueOf(serviceQName.getLocalPart()) + "_Description");
            for (EndpointBehaviour eb : this.getBehaviours()) {
                if (eb instanceof ProviderProxyBehaviour || eb.getBinding() == null) continue;
                Import impt = (Import)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Import.class);
                impt.setNamespace(eb.getBinding().getQName().getNamespaceURI());
                if (eb.getBinding().getDescription().getDocumentBaseURI() != null) {
                    URI imptUri = eb.getBinding().getDescription().getDocumentBaseURI();
                    impt.setLocation(imptUri.toString());
                    resolver.addImportedURI(imptUri);
                }
                def.addImport(impt);
            }
            com.ebmwebsourcing.easywsdl11.api.element.Service service = (com.ebmwebsourcing.easywsdl11.api.element.Service)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(com.ebmwebsourcing.easywsdl11.api.element.Service.class);
            service.setName(serviceQName.getLocalPart());
            def.addService(service);
            for (EndpointBehaviour eb : this.getBehaviours()) {
                System.out.println("zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz endpoint name = " + this.getQName());
                System.out.println("zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz endpoint behaviour = " + eb.getClass());
                if (eb instanceof ProviderProxyBehaviour || eb.getBinding() == null) continue;
                Port ep = (Port)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Port.class);
                ep.setBinding(eb.getBinding().getQName());
                ep.setName(this.getModel().getName().getLocalPart());
                Address addr = (Address)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Address.class);
                System.out.println("zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz addr = " + addr);
                addr.setLocation(serviceQName + "::" + this.getModel().getName().getLocalPart());
                SoapBindingHelper.setAddress((Port)ep, (Address)addr);
                System.out.println("zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz addr = " + addr.getLocation());
                service.addPort(ep);
            }
            desc = (Description)Factory.getInstance().wrap((XmlObject)def);
        }
        return desc;
    }
}

