/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.soa.impl.endpoint.thread;

import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationProducerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.thread.NotificationProducerThread;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.wsaddressing10.api.element.Address;
import com.ebmwebsourcing.wsaddressing10.api.element.ReferenceParameters;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.INotificationProducer;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.NotificationProducerEngine;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;
import java.net.URI;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jdom.JDOMException;
import org.w3c.dom.Document;

public class NotificationProducerThreadImpl
extends Thread
implements NotificationProducerThread {
    private static final Logger log = Logger.getLogger(NotificationProducerThreadImpl.class.getName());
    private final NotificationProducerEndpointBehaviour producerBehaviour;
    private final SubscriptionManagerEndpointBehaviour subscriptionManagerBehaviour;
    private final INotificationProducer producer;
    private final Document notifPayload;
    private final SOAPSender soapSender;
    private DocumentBuilderFactory documentFactory = null;
    private String dialect;
    private QName topicUsed;

    public NotificationProducerThreadImpl(NotificationProducerEndpointBehaviour producerbehaviour, SubscriptionManagerEndpointBehaviour subscriptionManagerBehaviour, Document notifPayload, QName topicUsed, String dialect) {
        this.producerBehaviour = producerbehaviour;
        this.subscriptionManagerBehaviour = subscriptionManagerBehaviour;
        this.producer = producerbehaviour.getNotificationProducer();
        this.notifPayload = notifPayload;
        this.soapSender = new SOAPSender();
        this.documentFactory = DocumentBuilderFactory.newInstance();
        this.documentFactory.setNamespaceAware(true);
        this.dialect = dialect;
        this.topicUsed = topicUsed;
    }

    @Override
    public void run() {
        String endpointNameAddress = null;
        try {
            List uuids = ((NotificationProducerEngine)this.producer).getSubsMgr().getStoredSubscriptionUuids();
            TopicExpressionType exp = NotificationProducerThreadImpl.createTopicExpression(this.topicUsed, this.dialect);
            boolean setCurrentMessage = false;
            for (String subscriptionId : uuids) {
                List topicExps = ((NotificationProducerEngine)this.producer).getSubsMgr().getTopicExpressionOfSubscription(subscriptionId);
                if (topicExps == null) continue;
                for (TopicExpressionType topicExp : topicExps) {
                    EndpointReferenceType currentConsumerEdp;
                    if (topicExp == null) continue;
                    String topicExpS = null;
                    String expS = null;
                    String xmlnstopic = topicExp.getContent().substring(0, topicExp.getContent().indexOf(":"));
                    String ns = this.findNS(topicExp.getTopicNamespaces(), xmlnstopic);
                    if (!QName.valueOf(topicExp.getContent()).getNamespaceURI().isEmpty()) {
                        topicExpS = topicExp.getContent();
                        expS = this.topicUsed.toString();
                    } else {
                        topicExpS = topicExp.getContent().substring(topicExp.getContent().indexOf(":") + 1);
                        expS = exp.getContent().substring(exp.getContent().indexOf(":") + 1);
                    }
                    if (!topicExpS.equals(expS) || (currentConsumerEdp = ((NotificationProducerEngine)this.producer).getSubsMgr().getConsumerEdpRefOfSubscription(subscriptionId)) == null) continue;
                    endpointNameAddress = currentConsumerEdp.getAddress().getValue().toString().indexOf("::") > 0 ? "{" + currentConsumerEdp.getAddress().getValue().toString().split("::")[0] + "}" + currentConsumerEdp.getAddress().getValue().toString().split("::")[1] : currentConsumerEdp.getAddress().getValue().toString();
                    EndpointType ep = ((RegistryEndpointBehaviour)this.producerBehaviour.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getEndpoint(QName.valueOf(endpointNameAddress));
                    String producerAddress = String.valueOf(((ProviderEndpoint)this.producerBehaviour.getEndpoint()).getQName().getNamespaceURI()) + "::" + ((ProviderEndpoint)this.producerBehaviour.getEndpoint()).getQName().getLocalPart();
                    Notify notify = NotificationProducerThreadImpl.createNotification(producerAddress, currentConsumerEdp.getAddress().getValue().toString(), subscriptionId, this.topicUsed, this.dialect, this.notifPayload);
                    ((NotificationProducerEngine)this.producer).setCurrentMessage(NotificationProducerThreadImpl.createTopicExpression(this.topicUsed, this.dialect), ((NotificationMessageHolderType)notify.getNotificationMessage().get(0)).getMessage(), false);
                    setCurrentMessage = true;
                    if (ep != null) {
                        Exchange ex = NotificationProducerThreadImpl.createMessageExchange((EndpointBehaviour)this.producerBehaviour, endpointNameAddress.toString(), notify);
                        log.info("send internal notification to: " + ex.getDestination());
                        this.producerBehaviour.getEndpoint().getNode().getTransportersManager().push(ex, ep.getNode());
                        continue;
                    }
                    Document request = RefinedWsnbFactory.getInstance().getWsnbWriter().writeNotifyAsDOM(notify);
                    this.soapSender.sendSoapRequest(SOAPSender.createSOAPMessageRequest((Document)request), currentConsumerEdp.getAddress().getValue().toString(), null);
                    log.info("Notification sended to " + currentConsumerEdp.getAddress().getValue().toString());
                }
            }
            if (!setCurrentMessage) {
                String producerAddress = String.valueOf(((ProviderEndpoint)this.producerBehaviour.getEndpoint()).getQName().getNamespaceURI()) + "::" + ((ProviderEndpoint)this.producerBehaviour.getEndpoint()).getQName().getLocalPart();
                Notify notify = NotificationProducerThreadImpl.createNotification(producerAddress, null, null, this.topicUsed, this.dialect, this.notifPayload);
                ((NotificationProducerEngine)this.producer).setCurrentMessage(NotificationProducerThreadImpl.createTopicExpression(this.topicUsed, this.dialect), ((NotificationMessageHolderType)notify.getNotificationMessage().get(0)).getMessage(), false);
            }
        }
        catch (TransportException e) {
            log.severe("Impossible to send notification to " + endpointNameAddress + " : " + e.getMessage());
        }
        catch (SOAPException e) {
            log.severe("Impossible to send notification to " + endpointNameAddress + " : " + e.getMessage());
        }
        catch (ESBException e) {
            log.severe("Impossible to send notification to " + endpointNameAddress + " : " + e.getMessage());
        }
        catch (JDOMException e) {
            log.severe("Impossible to send notification to " + endpointNameAddress + " : " + e.getMessage());
        }
        catch (WsnbException e) {
            log.severe("Impossible to send notification to " + endpointNameAddress + " : " + e.getMessage());
        }
        catch (AbsWSStarFault e) {
            log.severe("Impossible to send notification to " + endpointNameAddress + " : " + e.getMessage());
        }
    }

    private String findNS(List<QName> topicNamespaces, String xmlnstopic) {
        for (QName topic : topicNamespaces) {
            if (!topic.getLocalPart().equals(xmlnstopic)) continue;
            return topic.getNamespaceURI();
        }
        return null;
    }

    public static Exchange createMessageExchange(EndpointBehaviour behaviour, String endpointAddress, Notify notify) throws ESBException {
        Exchange message = null;
        try {
            EndpointType endpoint = ((RegistryEndpointBehaviour)behaviour.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getEndpoint(QName.valueOf(endpointAddress));
            if (endpoint == null) {
                throw new ESBException("Impossible to find endpoint: " + QName.valueOf(endpointAddress));
            }
            Document request = RefinedWsnbFactory.getInstance().getWsnbWriter().writeNotifyAsDOM(notify);
            String msg = XMLPrettyPrinter.prettyPrint((Document)request);
            message = MessageUtil.getInstance().createMessageExchange((ClientEndpoint)behaviour.getEndpoint(), endpoint.getName(), new QName("http://docs.oasis-open.org/wsn/bw-2", "NotificationConsumer"), new QName("http://docs.oasis-open.org/wsn/bw-2", "Notify"), PatternType.IN_ONLY, msg);
        }
        catch (TransportException e) {
            log.severe("Error: " + e.getMessage());
            throw new ESBException((Throwable)e);
        }
        catch (ESBException e) {
            log.severe("Error: " + e.getMessage());
            throw new ESBException((Throwable)e);
        }
        catch (WsnbException e) {
            log.severe("Error: " + e.getMessage());
            throw new ESBException((Throwable)e);
        }
        return message;
    }

    public static TopicExpressionType createTopicExpression(QName topicUsed, String dialect) throws ESBException {
        TopicExpressionType notifyTopicExpr = null;
        try {
            notifyTopicExpr = RefinedWsnbFactory.getInstance().createTopicExpressionType(URI.create(dialect));
            if (topicUsed.getPrefix() == null) {
                throw new ESBException("prefix of topicUsed cannot be null");
            }
            notifyTopicExpr.addTopicNamespace(topicUsed.getPrefix(), URI.create(topicUsed.getNamespaceURI()));
            notifyTopicExpr.setContent(String.valueOf(topicUsed.getPrefix()) + ":" + topicUsed.getLocalPart());
        }
        catch (WsnbException e) {
            throw new ESBException((Throwable)e);
        }
        return notifyTopicExpr;
    }

    public static Notify createNotification(String producerAddress, String endpointAddress, String uuid, QName topicUsed, String dialect, Document notifPayload) throws ESBException {
        Notify notifyPayload = null;
        try {
            Address address;
            NotificationMessageHolderType.Message mess = null;
            mess = notifPayload != null ? RefinedWsnbFactory.getInstance().createNotificationMessageHolderTypeMessage(notifPayload.getDocumentElement()) : RefinedWsnbFactory.getInstance().createNotificationMessageHolderTypeMessage(null);
            NotificationMessageHolderType msg = RefinedWsnbFactory.getInstance().createNotificationMessageHolderType(mess);
            notifyPayload = RefinedWsnbFactory.getInstance().createNotify(msg);
            if (topicUsed != null) {
                TopicExpressionType notifyTopicExpr = NotificationProducerThreadImpl.createTopicExpression(topicUsed, dialect);
                msg.setTopic(notifyTopicExpr);
            }
            if (endpointAddress != null && uuid != null) {
                EndpointReferenceType registrationRef = (EndpointReferenceType)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointReferenceType.class);
                address = (Address)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Address.class);
                address.setValue(URI.create(endpointAddress));
                registrationRef.setAddress(address);
                ReferenceParameters ref = (ReferenceParameters)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(ReferenceParameters.class);
                registrationRef.setReferenceParameters(ref);
                msg.setSubscriptionReference(registrationRef);
            }
            EndpointReferenceType producerRef = (EndpointReferenceType)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointReferenceType.class);
            address = (Address)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Address.class);
            address.setValue(URI.create(producerAddress));
            producerRef.setAddress(address);
            msg.setProducerReference(producerRef);
        }
        catch (WsnbException e) {
            throw new ESBException((Throwable)e);
        }
        return notifyPayload;
    }
}

