/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.impl.endpoint.thread;

import java.net.URI;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;

import org.jdom.JDOMException;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationProducerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.thread.NotificationProducerThread;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.wsaddressing10.api.element.Address;
import com.ebmwebsourcing.wsaddressing10.api.element.ReferenceParameters;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType.Message;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.INotificationProducer;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.NotificationProducerEngine;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;

public class NotificationProducerThreadImpl extends Thread implements NotificationProducerThread {


	private final static Logger log = Logger.getLogger(NotificationProducerThreadImpl.class
			.getName());

	private final NotificationProducerEndpointBehaviour producerBehaviour;

	private final SubscriptionManagerEndpointBehaviour subscriptionManagerBehaviour;

	private final INotificationProducer producer;

	private final Document notifPayload;

	private final SOAPSender soapSender;

	private DocumentBuilderFactory documentFactory = null;

	private String dialect;

	private QName topicUsed;

	public NotificationProducerThreadImpl(
			final NotificationProducerEndpointBehaviour producerbehaviour,
			final SubscriptionManagerEndpointBehaviour subscriptionManagerBehaviour,
			final Document notifPayload,
			final QName topicUsed,
			final String dialect) {
		this.producerBehaviour = producerbehaviour;
		this.subscriptionManagerBehaviour = subscriptionManagerBehaviour;
		this.producer = producerbehaviour.getNotificationProducer();
		this.notifPayload = notifPayload;
		this.soapSender = new SOAPSender();
		this.documentFactory = DocumentBuilderFactory.newInstance();
		this.documentFactory.setNamespaceAware(true);
		this.dialect = dialect;
		this.topicUsed = topicUsed;
	}


	public void run() {
		String endpointNameAddress = null;
		try {
			final List<String> uuids = ((NotificationProducerEngine)producer).getSubsMgr().getStoredSubscriptionUuids();

			TopicExpressionType exp = createTopicExpression(topicUsed, dialect);

			boolean setCurrentMessage = false;

			for (final String subscriptionId : uuids) {
				List<TopicExpressionType> topicExps = ((NotificationProducerEngine)producer).getSubsMgr().getTopicExpressionOfSubscription(subscriptionId);
				if(topicExps != null) {
					for(TopicExpressionType topicExp: topicExps) {
						if(topicExp != null) {
							
							String topicExpS = null;
							String expS = null; 
							
							String xmlnstopic = topicExp.getContent().substring(0, topicExp.getContent().indexOf(":"));
							String ns = findNS(topicExp.getTopicNamespaces(), xmlnstopic);
							
							//topicExp.getTopicNamespaces()
							if( ! QName.valueOf(topicExp.getContent()).getNamespaceURI().isEmpty() ) {
								topicExpS = topicExp.getContent();
								expS = topicUsed.toString();
							} else {
								topicExpS = topicExp.getContent().substring(topicExp.getContent().indexOf(":")+1);
								expS = exp.getContent().substring(exp.getContent().indexOf(":")+1);
							}
							
							if(topicExpS.equals(expS)) {
								EndpointReferenceType currentConsumerEdp = ((NotificationProducerEngine)producer).getSubsMgr().getConsumerEdpRefOfSubscription(subscriptionId);
								if (currentConsumerEdp != null){
									if(currentConsumerEdp.getAddress().getValue().toString().indexOf("::") > 0) {
										endpointNameAddress = "{" + currentConsumerEdp.getAddress().getValue().toString().split("::")[0] + "}" + currentConsumerEdp.getAddress().getValue().toString().split("::")[1];
									} else {
										endpointNameAddress = currentConsumerEdp.getAddress().getValue().toString();
									}
									final EndpointType ep = ((RegistryEndpointBehaviour)this.producerBehaviour.getEndpoint().getNode()
											.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getEndpoint(
													QName.valueOf(endpointNameAddress));
									
									String producerAddress = ((ProviderEndpoint) this.producerBehaviour.getEndpoint()).getQName().getNamespaceURI() + "::" + ((ProviderEndpoint) this.producerBehaviour.getEndpoint()).getQName().getLocalPart();
									final Notify notify = createNotification(producerAddress, currentConsumerEdp
											.getAddress().getValue().toString(), subscriptionId, topicUsed, dialect, this.notifPayload);
									((NotificationProducerEngine)this.producer).setCurrentMessage(this.createTopicExpression(topicUsed, dialect), notify.getNotificationMessage().get(0).getMessage(), false);
									setCurrentMessage = true;
									if (ep != null) {

										final Exchange ex = createMessageExchange(this.producerBehaviour, endpointNameAddress.toString(), notify);
										this.log.info("send internal notification to: "	+ ex.getDestination());
										this.producerBehaviour.getEndpoint().getNode()
										.getTransportersManager().push(ex,
												ep.getNode());
									} 
									/**
									 * this "else" should be removed ... easy way to access external service (used for notifications).
									 */
									else {

										final Document request = RefinedWsnbFactory.getInstance().getWsnbWriter().writeNotifyAsDOM(notify);
										this.soapSender.sendSoapRequest(this.soapSender.createSOAPMessageRequest(request), currentConsumerEdp
												.getAddress().getValue().toString(), null);
										this.log.info("Notification sended to " + currentConsumerEdp.getAddress().getValue().toString());
									}
								}
							}
						}
					}
				}
			}

			if(!setCurrentMessage) {
				String producerAddress = ((ProviderEndpoint) this.producerBehaviour.getEndpoint()).getQName().getNamespaceURI() + "::" + ((ProviderEndpoint) this.producerBehaviour.getEndpoint()).getQName().getLocalPart();
				Notify notify = createNotification(producerAddress, null, null, topicUsed, dialect, this.notifPayload);
				((NotificationProducerEngine)this.producer).setCurrentMessage(this.createTopicExpression(topicUsed, dialect), notify.getNotificationMessage().get(0).getMessage(), false);
			}



		} catch (final TransportException e) {
			this.log.severe("Impossible to send notification to " + endpointNameAddress + " : " + e.getMessage());
		} catch (final SOAPException e) {
			this.log.severe("Impossible to send notification to " + endpointNameAddress + " : " + e.getMessage());
		} catch (ESBException e) {
			this.log.severe("Impossible to send notification to " + endpointNameAddress + " : " + e.getMessage());
		} catch (JDOMException e) {
			this.log.severe("Impossible to send notification to " + endpointNameAddress + " : " + e.getMessage());
		} catch (WsnbException e) {
			this.log.severe("Impossible to send notification to " + endpointNameAddress + " : " + e.getMessage());
		} catch (AbsWSStarFault e) {
			this.log.severe("Impossible to send notification to " + endpointNameAddress + " : " + e.getMessage());
		} 
	}


	private String findNS(List<QName> topicNamespaces, String xmlnstopic) {
        for(QName topic : topicNamespaces){
            if(topic.getLocalPart().equals(xmlnstopic)){
                return topic.getNamespaceURI();
            }
        }
        return null;
    }


    public static Exchange createMessageExchange(EndpointBehaviour behaviour, String endpointAddress, Notify notify) throws ESBException {
		Exchange message = null;
		try {
			// find destination endpoint
			final EndpointType endpoint = ((RegistryEndpointBehaviour)behaviour.getEndpoint().getNode()
					.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getEndpoint(QName.valueOf(endpointAddress));

			if (endpoint == null) {
				throw new ESBException("Impossible to find endpoint: "
						+ QName.valueOf(endpointAddress));
			}

			// marshall response
			String msg;

			//			final Notify notify = this.createQosMetricNotification(
			//					endpointAddress, uuid, metrics);
			final Document request = RefinedWsnbFactory.getInstance().getWsnbWriter().writeNotifyAsDOM(notify);

			msg = XMLPrettyPrinter.prettyPrint(request);
			message = MessageUtil.getInstance()
			.createMessageExchange(
					(ClientEndpoint) behaviour.getEndpoint(),
					endpoint.getName(),
					new QName("http://docs.oasis-open.org/wsn/bw-2","NotificationConsumer"),
					new QName(
							"http://docs.oasis-open.org/wsn/bw-2",
					"Notify"), PatternType.IN_ONLY, msg);
		} catch (final TransportException e) {
			log.severe("Error: " + e.getMessage());
			throw new ESBException(e);
		} catch (ESBException e) {
			log.severe("Error: " + e.getMessage());
			throw new ESBException(e);
		} catch (WsnbException e) {
			log.severe("Error: " + e.getMessage());
			throw new ESBException(e);
		}
		return message;
	}



	public static TopicExpressionType createTopicExpression(QName topicUsed, String dialect) throws ESBException {
		TopicExpressionType notifyTopicExpr =  null;

		try {
			notifyTopicExpr = RefinedWsnbFactory.getInstance().createTopicExpressionType(URI.create(dialect));



			if(topicUsed.getPrefix() == null) {
				throw new ESBException("prefix of topicUsed cannot be null");
			}


			notifyTopicExpr.addTopicNamespace(topicUsed.getPrefix(),
					URI.create(topicUsed.getNamespaceURI()));
			notifyTopicExpr.setContent(topicUsed.getPrefix() + ":" + topicUsed.getLocalPart());
		} catch (WsnbException e) {
			throw new ESBException(e);
		} 
		return notifyTopicExpr;
	}


	public static Notify createNotification(String producerAddress, String endpointAddress, String uuid, 
			QName topicUsed, String dialect, Document notifPayload) throws ESBException {
		Notify notifyPayload = null;
		try {
			Message mess = null;
			if(notifPayload != null) {
				mess = RefinedWsnbFactory.getInstance()
				.createNotificationMessageHolderTypeMessage(notifPayload.getDocumentElement());
			} else {
				mess = RefinedWsnbFactory.getInstance()
				.createNotificationMessageHolderTypeMessage(null);
			}
			NotificationMessageHolderType msg = RefinedWsnbFactory
			.getInstance().createNotificationMessageHolderType(mess);
			notifyPayload = RefinedWsnbFactory.getInstance().createNotify(msg);

			if(topicUsed != null) {
				final TopicExpressionType notifyTopicExpr = createTopicExpression(topicUsed, dialect);
				msg.setTopic(notifyTopicExpr);
			}

			if(endpointAddress != null && uuid != null) {
				final EndpointReferenceType registrationRef = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointReferenceType.class);
				Address address = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Address.class);
				address.setValue(URI.create(endpointAddress));
				registrationRef.setAddress(address);

				final ReferenceParameters ref = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(ReferenceParameters.class);
				registrationRef.setReferenceParameters(ref);

				msg.setSubscriptionReference(registrationRef);
			}
			final EndpointReferenceType producerRef = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointReferenceType.class);
			Address address = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Address.class);
			address.setValue(URI.create(producerAddress));
			producerRef.setAddress(address);
			msg.setProducerReference(producerRef);


		} catch (WsnbException e) {
			throw new ESBException(e);
		}
		return notifyPayload;
	}
}
