/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.impl.service;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.api.service.BusinessService;
import com.ebmwebsourcing.easyesb.soa10.api.type.BusinessServiceType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;

@Scope("COMPOSITE")
@Service(value=BusinessService.class, names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public class BusinessServiceImpl<M extends BusinessServiceType> extends ServiceImpl<M> implements BusinessService<M> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public BusinessServiceImpl() {
		super();
	}
	
	public BusinessServiceImpl(M model, SOAElement<?> parent) throws ESBException {
		super(model, parent);
		if(parent != null) {
			this.model.setComponentParent(((ComponentType)parent.getModel()).getName());
		}
	}
	
	public Class<M> getModelClass() {
		Class<M> res = null;
		if(model != null) {
			res = (Class<M>) model.getClass();
		} else {
			res = (Class<M>) BusinessServiceType.class;
		}
		return res;
	}


}
