/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.impl.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;

import com.ebmwebsourcing.easybox.api.XmlObjectFactory;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa.api.factory.ESBCoreFactory;
import com.ebmwebsourcing.easyesb.soa.api.factory.creation.AbstractComponentCreationFactory;
import com.ebmwebsourcing.easyesb.soa.api.factory.creation.AbstractExternalServerCreationFactory;
import com.ebmwebsourcing.easyesb.soa.api.factory.creation.AbstractServiceCreationFactory;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryService;
import com.ebmwebsourcing.easyesb.soa.api.transport.TransportersManager;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.soa.impl.node.NodeBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.node.NodeImpl;
import com.ebmwebsourcing.easyesb.soa.impl.transport.listener.ListenersManagerImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.BehavioursList;
import com.ebmwebsourcing.easyesb.soa10.api.element.ClientEndpointsGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.ServicesGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.NodeType;
import com.ebmwebsourcing.easyesb.soa10.api.type.RegistryServiceType;



public class ESBCoreFactoryImpl implements ESBCoreFactory {

	private static Logger log = Logger.getLogger(ESBCoreFactoryImpl.class.getName());

	protected Map<String, AbstractServiceCreationFactory> servicesFactory = new HashMap<String, AbstractServiceCreationFactory>();

	protected Map<String, AbstractComponentCreationFactory> componentsFactory = new HashMap<String, AbstractComponentCreationFactory>();

	protected Map<String, AbstractExternalServerCreationFactory> externalServersFactory = new HashMap<String, AbstractExternalServerCreationFactory>();

	private List<String> factoryToExclude = null;

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(easybox.easyesb.petalslink.com.soa.model.datatype._1.ObjectFactory.class,
					easyesb.ebmwebsourcing.com.soa.model.endpoint.ObjectFactory.class,
					easyesb.ebmwebsourcing.com.soa.model.service.ObjectFactory.class,
					easyesb.ebmwebsourcing.com.soa.model.component.ObjectFactory.class,
					easyesb.ebmwebsourcing.com.soa.model.node.ObjectFactory.class,
					easyesb.ebmwebsourcing.com.soa.model.registry.ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}

	public ESBCoreFactoryImpl(String... factoryToExclude) {
		this.factoryToExclude = Arrays.asList(factoryToExclude);
	}

	public Node createNode(QName name, Configuration config) throws ESBException {
		Node node = null;


		try {
			XmlObjectFactory factory = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory();
			com.ebmwebsourcing.easyesb.soa10.api.element.Node model = factory.create(com.ebmwebsourcing.easyesb.soa10.api.element.Node.class);
			model.setName(name);
			model.setBehavioursList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(BehavioursList.class));
			model.getBehavioursList().addBehaviour(NodeBehaviourImpl.class.getName());


			Map<String, Object> context = new HashMap<String, Object>();
			context.put("model", model);

			Component nodeComponent = SCAHelper.getSCAHelper().createNewComponent(NodeImpl.class.getName(), context);;
			SCAHelper.getSCAHelper().startComponent(nodeComponent);

			if(name != null) {
				SCAHelper.getSCAHelper().changeName(nodeComponent, name.toString());
			}

			node = (Node)nodeComponent.getFcInterface("service");
			node.init();
			((com.ebmwebsourcing.easyesb.soa10.api.element.Node)node.getModel()).setClientEndpointsGroupList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(ClientEndpointsGroupList.class));
			node.setNode(node);
			node.getModel().setEndpointInitialContext(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class));
			((NodeType)node.getModel()).setServicesGroupList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(ServicesGroupList.class));

			((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).setConfiguration(config);


			// create registry
			if(config.getRegistryServiceClass() == null) {
				log.warning("No Registry Service defined. Distributed communication is not possible!!!!");
			} else {
				EndpointInitialContext initialEndpointContext = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);
				initialEndpointContext.setNumberOfThreads(5);

				RegistryService<RegistryServiceType> registry = (RegistryService<RegistryServiceType>) ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createRegistryService(name.getLocalPart() + "_registry", config.getRegistryServiceClass(), config.getRegistryServiceBehaviourClass(), initialEndpointContext);
			}

			// create transporterManager
			TransportersManager transportersManager = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createTransportersManager(name.getLocalPart() + "_transporterManager");
			transportersManager.setNode(node);

			// create listener or add endpoint in listener node
			if((node.getModel().getEndpointInitialContext() != null)&&(node.getModel().getEndpointInitialContext().getNumberOfThreads() > 0)) {
				Map<QName, Endpoint<? extends EndpointType>> endpoints = Collections.synchronizedMap(new HashMap<QName, Endpoint<? extends EndpointType>>());
				endpoints.put(node.getQName(), node);
				node.setListenersManager(new ListenersManagerImpl(node.getModel().getEndpointInitialContext().getNumberOfThreads(), endpoints));
			} else {
				node.getListenedEndpoints().put(node.getQName(), node);
			}


			// create external server
			createSPIExternalServer(node, config.getProperties());

			// create SPI service
			createSPIService(node, config);

			// create SPI component
			createSPIComponent(node, config);

		} catch (NoSuchInterfaceException e) {
			throw new ESBException(e);
		} catch (SCAException e) {
			throw new ESBException(e);
		}
		log.fine("node " + name + " created and started");
		return node;
	}



	private void createSPIExternalServer(Node node, Map<String, String> properties) throws ESBException {
		ServiceLoader<AbstractExternalServerCreationFactory> componentLoader = ServiceLoader.load(AbstractExternalServerCreationFactory.class);
		componentLoader.reload();
		Iterator<AbstractExternalServerCreationFactory> commandsIterator = componentLoader.iterator();
		while (commandsIterator.hasNext()) {
			AbstractExternalServerCreationFactory command = commandsIterator.next();
			if(!this.factoryToExclude.contains(command.getId())) {
				ExternalServer server = command.createExternalServer(this, properties);
				externalServersFactory.put(command.getId(), command);
				((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).addExternalServer(server);
				log.info("SPI: external server \"" + command.getId() + "\" is created");
			}
		}
	}



	private void createSPIComponent(Node node, Configuration conf) throws ESBException {
		ServiceLoader<AbstractComponentCreationFactory> componentLoader = ServiceLoader.load(AbstractComponentCreationFactory.class);
		componentLoader.reload();
		Iterator<AbstractComponentCreationFactory> commandsIterator = componentLoader.iterator();
		while (commandsIterator.hasNext()) {
			AbstractComponentCreationFactory command = commandsIterator.next();
			if(!this.factoryToExclude.contains(command.getId())) {
				command.createComponent(this, node, conf);
				componentsFactory.put(command.getId(), command);
				log.info("SPI: component \"" + command.getId() + "\" is created");
			}
		}
	}



	private void createSPIService(Node node, Configuration conf) throws ESBException {
		ServiceLoader<AbstractServiceCreationFactory> serviceLoader = ServiceLoader.load(AbstractServiceCreationFactory.class);
		serviceLoader.reload();
		Iterator<AbstractServiceCreationFactory> commandsIterator = serviceLoader.iterator();
		while (commandsIterator.hasNext()) {
			AbstractServiceCreationFactory command = commandsIterator.next();
			if(!this.factoryToExclude.contains(command.getId())) {
				command.createService(this, node, conf);
				servicesFactory.put(command.getId(), command);
				log.info("SPI: service \"" + command.getId() + "\" is created");
			}
		}
	}



	public Configuration getDefaultConfiguration() throws ESBException {
		return new ConfigurationImpl();
	}	
}
