/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.impl.node;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.component.ComponentBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.Interceptor;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryService;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.transport.TransportersManager;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.component.AbstractComponentBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.transport.TransportersManagerImpl;
import com.ebmwebsourcing.easyesb.soa.impl.transport.listener.ListenersManagerImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.BehavioursList;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.ProviderEndpointsGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.element.Registry;
import com.ebmwebsourcing.easyesb.soa10.api.element.ServicesGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.type.ClientEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.NodeType;
import com.ebmwebsourcing.easyesb.soa10.api.type.RegistryServiceType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyesb.transporter.api.transport.Transporter;
import com.ebmwebsourcing.easyesb.transporter.impl.soap.SOAPTransportContext;
import com.ebmwebsourcing.easyesb.transporter.impl.soap.SOAPTransporterImpl;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbEndpointType;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easyesb.ebmwebsourcing.com.soa.model.node.GetInformations;
import easyesb.ebmwebsourcing.com.soa.model.node.GetInformationsResponse;
import easyesb.ebmwebsourcing.com.soa.model.registry.RegistryFault_Exception;
import esstar.petalslink.com.service.management._1_0.ManagementException;


public class NodeBehaviourImpl extends AbstractComponentBehaviourImpl implements NodeBehaviour {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(NodeBehaviourImpl.class.getName());

	private String adminExternalEndpoint = null;
	
	private List<Component<? extends ComponentType>> components = new ArrayList<Component<? extends ComponentType>>();

	private TransportersManager transporter;

	private Configuration config = null;

	private RegistryService<RegistryServiceType> registryService;

	private Map<String, ExternalServer> servers = new HashMap<String, ExternalServer>();

	private List<ClientEndpoint<? extends ClientEndpointType>> clientEndpoints = new ArrayList<ClientEndpoint<? extends ClientEndpointType>>();

	private Map<TopicSetType, Interceptor> interceptorSubscribers = new HashMap<TopicSetType, Interceptor>();

	private Map<TopicSetType, Endpoint<?>> endpointSubscribers = new HashMap<TopicSetType, Endpoint<?>>();

	public NodeBehaviourImpl(Node<? extends NodeType> ep) {
		super(ep);
		try {
			URL url = Thread.currentThread().getContextClassLoader().getResource(DESCRIPTION_NODE_URL);
			Description desc = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasyESBFramework.getInstance()).get().readDocument(url, Definitions.class));
			this.setBinding(desc.getBindings().iterator().next());
		} catch (XmlObjectReadException e) {
			e.printStackTrace();
			throw new RuntimeException();
		} 
	}

	public TransportersManager getTransportersManager() {
		return this.transporter;
	}

	public List<Component<? extends ComponentType>> getComponents() {
		return this.components;
	}

	public List<ClientEndpoint<? extends ClientEndpointType>> getClientEndpoints() {
		return this.clientEndpoints;
	}


	@SuppressWarnings("unchecked")
	public <CE extends ClientEndpoint<? extends ClientEndpointType>> CE createClientEndpoint(QName name, Class<CE> clientEndpointClass, Class<? extends EndpointBehaviour> clientEndpointBehaviourClass, EndpointInitialContext initialEndpointContext) throws ESBException {
		CE clientEndpoint = null;
		try {

			// create model
			ClientEndpointType model = null;
			if(ProviderProxyEndpoint.class.isAssignableFrom(clientEndpointClass)) {
				model = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(com.ebmwebsourcing.easyesb.soa10.api.element.ProviderProxyEndpoint.class);
			} else if(ProviderEndpoint.class.isAssignableFrom(clientEndpointClass)) {
				model = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(com.ebmwebsourcing.easyesb.soa10.api.element.ProviderEndpoint.class);
			} else if(ClientProxyEndpoint.class.isAssignableFrom(clientEndpointClass)) {
				model = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(com.ebmwebsourcing.easyesb.soa10.api.element.ClientProxyEndpoint.class);
			} else if(ClientEndpoint.class.isAssignableFrom(clientEndpointClass)) {
				model = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(com.ebmwebsourcing.easyesb.soa10.api.element.ClientEndpoint.class);
			} else {
				throw new ESBException("No implementation correspond to this class: " + clientEndpointClass); 
			}
			model.setBehavioursList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(BehavioursList.class));
			model.getBehavioursList().addBehaviour(clientEndpointBehaviourClass.getName());
			model.setType(clientEndpointClass.getName());
			model.setEndpointInitialContext(initialEndpointContext);

			model.setName(name);
			model.setNode(this.getNodeQName());
			model.setBasicNodeInformations(this.endpoint.getModel().getBasicNodeInformations());


			RegistryService<?> registryService = ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getRegistryService();
			if(registryService != null) {

				// add consumerEndpoint in registry
				boolean res = ((RegistryEndpointBehaviour)((RegistryServiceBehaviour)((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getRegistryService().findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addEndpoint((EJaxbEndpointType) model.getModelObject());

				// set listener manager
				//clientEndpoint.setListenersManager(new ListenersManagerImpl(clientEndpoint));

				if(res) {
					// get component
					clientEndpoint = (CE) ((RegistryEndpointBehaviour) ((RegistryServiceBehaviour)((NodeBehaviour)this.getEndpoint().findBehaviour(NodeBehaviour.class)).getRegistryService().findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(model.getName());
					NodeType nt = (NodeType) this.endpoint.getModel();
					nt.getClientEndpointsGroupList().addClientEndpoint((ClientEndpointType) model);
				}
			} else {

				Map<String, Object> context = new HashMap<String, Object>();
				context.put("model", model);
				context.put("parent", this.getEndpoint());

				// add consumeEndpoint in registry
				// create component in composite
				org.objectweb.fractal.api.Component clientEndpointComponent = SCAHelper.getSCAHelper().createNewComponent(clientEndpointClass.getName(), context);
				SCAHelper.getSCAHelper().addComponent(clientEndpointComponent, this.getEndpoint().getComponent(), null);
				SCAHelper.getSCAHelper().startComponent(clientEndpointComponent);

				if(name != null) {
					SCAHelper.getSCAHelper().changeName(clientEndpointComponent, name.toString());
				}

				clientEndpoint = (CE) clientEndpointComponent.getFcInterface("service");
				clientEndpoint.setNode((Node) this.getEndpoint().getNode());
				clientEndpoint.init();


				// create listener or add endpoint in listener node
				if((clientEndpoint.getModel().getEndpointInitialContext() != null)&&(clientEndpoint.getModel().getEndpointInitialContext().getNumberOfThreads() > 0)) {
					Map<QName, Endpoint<? extends EndpointType>> endpoints = Collections.synchronizedMap(new HashMap<QName, Endpoint<? extends EndpointType>>());
					endpoints.put(clientEndpoint.getQName(), clientEndpoint);
					clientEndpoint.setListenersManager(new ListenersManagerImpl(clientEndpoint.getModel().getEndpointInitialContext().getNumberOfThreads(), endpoints));
				} else {
					this.getEndpoint().getNode().getListenedEndpoints().put(clientEndpoint.getQName(), clientEndpoint);
				}

			}
		} catch (SecurityException e) {
			throw new ESBException(e);
		} catch (IllegalArgumentException e) {
			throw new ESBException(e);
		} catch (RegistryFault_Exception e) {
			throw new ESBException(e);
		} catch (SCAException e) {
			throw new ESBException(e);
		} catch (NoSuchInterfaceException e) {
			throw new ESBException(e);
		} 
		log.fine("clientEndpoint " + name + " created and started");
		return clientEndpoint;
	}



	@SuppressWarnings("unchecked")
	public <C extends Component<? extends ComponentType>> C createComponent(QName name, Class<C> componentClassName) throws ESBException {
		C component = null;
		try {
			ComponentType model = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(com.ebmwebsourcing.easyesb.soa10.api.element.Component.class);
			model.setName(name);
			model.setType(componentClassName.getName());


			model.setBehavioursList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(BehavioursList.class));
		//	model.getBehavioursList().addBehaviour(ComponentBehaviourImpl.class.getName());

			model.setNode(this.getNodeQName());
			model.setService(this.getNodeQName());
			model.setBasicNodeInformations(this.endpoint.getModel().getBasicNodeInformations());
			model.setEndpointInitialContext(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class));
			model.setServicesGroupList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(ServicesGroupList.class));

			RegistryService<?> registryService = ((NodeBehaviour)this.getEndpoint().findBehaviour(NodeBehaviour.class)).getRegistryService();
			if(registryService != null) {

				// add component in registry
				boolean res = ((RegistryEndpointBehaviour) ((RegistryServiceBehaviour)registryService.findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addEndpoint((EJaxbEndpointType) model.getModelObject());

				if(res) {
					// get component
					component = (C) ((RegistryEndpointBehaviour) ((RegistryServiceBehaviour)((NodeBehaviour)this.getEndpoint().findBehaviour(NodeBehaviour.class)).getRegistryService().findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(model.getName());

					NodeType nt = (NodeType) this.endpoint.getModel();
					nt.addComponent((com.ebmwebsourcing.easyesb.soa10.api.element.Component) model);
				}
				// add endpoint in listener
				//this.getListenedEndpoints().put(component.getQName(), component);
			} else {

				Map<String, Object> context = new HashMap<String, Object>();
				context.put("model", model);
				context.put("parent", this.getEndpoint());

				// create component in composite
				org.objectweb.fractal.api.Component componentComponent = SCAHelper.getSCAHelper().createNewComponent(componentClassName.getName(), context);
				SCAHelper.getSCAHelper().addComponent(componentComponent, this.getEndpoint().getComponent(), null);
				SCAHelper.getSCAHelper().startComponent(componentComponent);

				if(name != null) {
					SCAHelper.getSCAHelper().changeName(componentComponent, name.toString());
				}

				component = (C) componentComponent.getFcInterface("service");
				component.init();

				// init
				component.setNode((Node) this.getEndpoint());


				// create listener or add endpoint in listener node
				if((component.getModel().getEndpointInitialContext() != null)&&(component.getModel().getEndpointInitialContext().getNumberOfThreads() > 0)) {
					Map<QName, Endpoint<? extends EndpointType>> endpoints = Collections.synchronizedMap(new HashMap<QName, Endpoint<? extends EndpointType>>());
					endpoints.put(component.getQName(), component);
					component.setListenersManager(new ListenersManagerImpl(component.getModel().getEndpointInitialContext().getNumberOfThreads(), endpoints));
				} else {
					this.getEndpoint().getNode().getListenedEndpoints().put(component.getQName(), component);
				}

			}

		} catch (RegistryFault_Exception e) {
			e.printStackTrace();
			throw new ESBException(e);
		} catch (SCAException e) {
			e.printStackTrace();
			throw new ESBException(e);
		} catch (NoSuchInterfaceException e) {
			e.printStackTrace();
			throw new ESBException(e);
		}
		log.fine("component " + name + " created and started");
		return component;
	}




	public TransportersManager createTransportersManager(String name) throws ESBException {
		TransportersManager transporter = null;
		try {
			org.objectweb.fractal.api.Component transporterComponent = SCAHelper.getSCAHelper().createNewComponent(TransportersManagerImpl.class.getName(), null);
			SCAHelper.getSCAHelper().startComponent(transporterComponent);

			if(name != null) {
				SCAHelper.getSCAHelper().changeName(transporterComponent, name);
			} else {
				throw new ESBException("name cannot be null");
			}

			transporter = (TransportersManager)transporterComponent.getFcInterface("service");

			// init
			//transporter.initFractalComponent(transporterComponent);
			transporter.setQName(new QName(this.getEndpoint().getQName().getNamespaceURI(), name));
			//transporter.setNode(this.getEndpoint());

			// create SOAPTransporter
			Transporter soapTransporter = transporter.createTransporter("SOAPTransporter", SOAPTransporterImpl.class);
			SOAPTransportContext context = new SOAPTransportContext();
			context.setNodeName(this.getEndpoint().getQName());
			context.setHttpAddress(this.getSOAPTransporterAddress());


			soapTransporter.setContext(context);//Thread Safe ???? Frascati ???

			// add component in list
			SCAHelper.getSCAHelper().addComponent(transporterComponent, this.getEndpoint().getComponent(), null);
			this.transporter = transporter;

			// add endpoint in registry
			//((RegistryBehaviour)this.registry.getBehaviour()).addEndpoint(transporter);

			// add endpoint in listener
			//this.getListenedEndpoints().put(this.transporter.getQName(), this.transporter);

		} catch (NoSuchInterfaceException e) {
			throw new ESBException(e);
		} catch (SCAException e) {
			throw new ESBException(e);
		}
		log.fine("transporterManager " + name + " created and started");
		return transporter;
	}


	public String getHost() {
		return ((NodeType)this.getEndpoint().getModel()).getBasicNodeInformations().getHost();
	}


	public void setHost(String ip) {
		this.getEndpoint().getModel().getBasicNodeInformations().setHost(ip);
	}	

	public String getPort() {
		return ((NodeType)this.getEndpoint().getModel()).getBasicNodeInformations().getPort();
	}

	public void setPort(String port) {
		((NodeType)this.getEndpoint().getModel()).getBasicNodeInformations().setPort(port);
	}

	public void execute(Exchange exchange) throws TransportException {
		super.execute(exchange);
		try {
			log.finest("Component BEHAVIOUR FOUND: " + exchange.getOperation());
			log.finest("Component BEHAVIOUR FOUND: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageIn().printMessage()));

			if (QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("getInformations") &&
					QName.valueOf(exchange.getOperation()).getNamespaceURI()
					.equals("http://com.ebmwebsourcing.easyesb/soa/model/node")) {
				log.finest("getInformations");

				GetInformations request = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetInformations.class);
				GetInformationsResponse response = new GetInformationsResponse();
				response.setNode(this.getInformations());

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);
				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} 
		} catch (SOAException e) {
			log.severe("ESB Exception: " + e.getMessage());
			throw new TransportException(e);
		} 
	}

	@SuppressWarnings("unchecked")
	public RegistryService<RegistryServiceType> createRegistryService(
			String name, Class<? extends RegistryService> serviceRegistryClass, Class<? extends RegistryServiceBehaviour> serviceRegistryBehaviourClass, EndpointInitialContext initialEndpointContext) throws ESBException {


		if(this.registryService == null) {
			try {
				RegistryServiceType model = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(RegistryServiceType.class);
				model.setName(new QName(this.getEndpoint().getQName().getNamespaceURI(),name));
				model.setBehavioursList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(BehavioursList.class));
				model.getBehavioursList().addBehaviour(serviceRegistryBehaviourClass.getName());
				Map<String, Object> context = new HashMap<String, Object>();
				context.put("model", model);
				context.put("parent", this.getEndpoint());

				org.objectweb.fractal.api.Component providerComponent = SCAHelper.getSCAHelper().createNewComponent(serviceRegistryClass.getName(), context);
				SCAHelper.getSCAHelper().startComponent(providerComponent);
				if(name != null) {
					SCAHelper.getSCAHelper().changeName(providerComponent, name.toString());
				}

				this.registryService = (RegistryService) providerComponent.getFcInterface("service");

				// init
				this.registryService.init();

				this.registryService.addBehaviourClass(serviceRegistryBehaviourClass);

				this.registryService.setNode(this.getEndpoint().getNode());
				this.registryService.getModel().setEndpointInitialContext(initialEndpointContext);

				this.registryService.getModel().setBasicNodeInformations(this.endpoint.getModel().getBasicNodeInformations());

				this.registryService.getModel().setProviderEndpointsGroupList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(ProviderEndpointsGroupList.class));

				// add component in list
				if(this.getEndpoint().getComponent() != null) {
					SCAHelper.getSCAHelper().addComponent(providerComponent, this.getEndpoint().getComponent(), null);
				}

				// create listener or add endpoint in listener node
				if((this.registryService.getModel().getEndpointInitialContext() != null)&&(this.registryService.getModel().getEndpointInitialContext().getNumberOfThreads() > 0)) {
					Map<QName, Endpoint<? extends EndpointType>> endpoints = Collections.synchronizedMap(new HashMap<QName, Endpoint<? extends EndpointType>>());
					endpoints.put(this.registryService.getQName(), this.registryService);
					this.registryService.setListenersManager(new ListenersManagerImpl(this.registryService.getModel().getEndpointInitialContext().getNumberOfThreads(), endpoints));
				} else {
					this.getEndpoint().getNode().getListenedEndpoints().put(this.registryService.getQName(), this.registryService);
				}
			} catch (NoSuchInterfaceException e) {
				throw new ESBException(e);
			} catch (SCAException e) {
				throw new ESBException(e);
			} catch (SecurityException e) {
				throw new ESBException(e);
			} catch (IllegalArgumentException e) {
				throw new ESBException(e);
			} 
			log.fine("registryService " + name + " created and started");

			// create registry endpoint
			((RegistryServiceBehaviour)	this.registryService.findBehaviour(RegistryServiceBehaviour.class)).createRegistryEndpoint("registryEndpoint_" + this.getNodeQName().getLocalPart(), initialEndpointContext);

			// set registry model in node
			this.getEndpoint().getNode().getModel().setRegistry((Registry) ((RegistryServiceBehaviour)	this.registryService.findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().getModel());
		}
		return this.registryService;
	}

	public RegistryService<RegistryServiceType> getRegistryService() {
		return this.registryService;
	}

	public Configuration getConfiguration() {
		return this.config;
	}

	public void setConfiguration(Configuration config) {
		this.config = config;
		this.setHost(this.config.getHost());
		this.setPort(String.valueOf(this.config.getPort()));
	}

	public String getSOAPTransporterAddress() {
		return MessageUtil.getInstance().getSOAPTransporterAddress(this.getHost(), this.getPort());
	}

	@SuppressWarnings("unchecked")
	public easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbNodeType getInformations() {
		return (easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbNodeType) this.getEndpoint().getNode().getModel().getModelObject();
	}

	public void addExternalServer(ExternalServer server) {
		this.servers.put(server.getName(), server);
	}

	public ExternalServer getExternalServer(String name) {
		return this.servers.get(name);
	}

	public List<ExternalServer> getExternalServers() {
		return new ArrayList<ExternalServer>(this.servers.values());
	}

	public ClientEndpoint<? extends ClientEndpointType> getClientEndpoint(
			QName name) {
		ClientEndpoint<? extends ClientEndpointType> res = null;
		for(ClientEndpoint<? extends ClientEndpointType> ce: this.clientEndpoints) {
			if(ce.getQName().equals(name)) {
				res = ce;
				break;
			}
		}
		return res;
	}

	public Component<? extends ComponentType> getComponent(
			QName name) {
		Component<? extends ComponentType> res = null;
		for(Component<? extends ComponentType> c: this.components) {
			if(c.getQName().equals(name)) {
				res = c;
				break;
			}
		}
		return res;
	}

	public ClientEndpoint<? extends ClientEndpointType> removeClientEndpoint(
			ClientEndpoint<? extends ClientEndpointType> ce) throws ESBException {
		ClientEndpoint<? extends ClientEndpointType> res = null;
		res = this.getClientEndpoint(ce.getQName());
		if(res != null) {
			// delete model
			NodeType nt = (NodeType) this.endpoint.getModel();
			nt.getClientEndpointsGroupList().removeClientEndpoint((com.ebmwebsourcing.easyesb.soa10.api.element.ClientEndpoint) res.getModel());


			// delete in list
			this.clientEndpoints.remove(res);

			// delete in registry
			((RegistryEndpointBehaviour)this.endpoint.getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).removeLocalEndpoint(res);

		}
		return res;
	}

	public Component<? extends ComponentType> removeComponent(
			Component<? extends ComponentType> ce) throws ESBException {
		Component<? extends ComponentType> res = null;
		res = this.getComponent(ce.getQName());
		if(res != null) {
			// delete model
			NodeType nt = (NodeType) this.endpoint.getModel();
			nt.removeComponent((com.ebmwebsourcing.easyesb.soa10.api.element.Component) res.getModel());


			// delete in list
			this.clientEndpoints.remove(res);

			// delete in registry
			((RegistryEndpointBehaviour)this.endpoint.getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).removeLocalEndpoint(res);

		}
		return res;
	}


	public boolean isStopped(){

		if(this.getTransportersManager() != null){
			if(!this.getTransportersManager().isStopped()){
				return false;
			}
		}
		if(servers.values().size()>0){
			for(ExternalServer server : servers.values()){
				if(!server.isStopped()){
					return false;
				}
			}
			return true;
		}else{
			return true;
		}
	}


	@Override
	public void setTransportersManager(TransportersManager tm) {
		this.transporter = tm;
	}

	@Override
	public Map<TopicSetType, Interceptor> getInterceptorSubscribers() {
		return this.interceptorSubscribers;
	}

	@Override
	public Map<TopicSetType, Endpoint<?>> getEndpointSubscribers() {
		return this.endpointSubscribers;
	}

	@Override
	public Endpoint<?> getEndpointFromTopicQName(QName topic) {
		for(Entry<TopicSetType, Endpoint<?>> entry: this.endpointSubscribers.entrySet()) {
			TopicSetType topicSet = entry.getKey();
			for(Element elmt: topicSet.getTopicsTrees()) {
				if(topic.getNamespaceURI().equals(elmt.getNamespaceURI()) &&
						topic.getLocalPart().equals(elmt.getLocalName())) {
					return entry.getValue();
				}
			}
		}
		return null;
	}

	@Override
	public void setAdminExternalEndpoint(String endpoint) {
		this.adminExternalEndpoint = endpoint;
	}

	@Override
	public String getAdminExternalEndpoint() {
		return this.adminExternalEndpoint;
	}

	@Override
	public Map<String, Component> getDeployableResourcesByComponent() {
		Map<String, Component> map = new HashMap<String, Component>();
		for(Component c: this.getComponents()) {
			for(String ext: ((ComponentBehaviour)c.findBehaviour(ComponentBehaviour.class)).getSupportedResourcesExtensions()) {
				map.put(ext, c);
			}
		}
		return map;
	}

	@Override
	public EJaxbDeployResponse deploy(EJaxbDeploy parameters)
			throws ManagementException {
		EJaxbDeployResponse result = null;
		String fileURL = parameters.getMainResource().getFileURI();
		String extension = FileUtil.getExtension(fileURL);
		Component c = this.getDeployableResourcesByComponent().get(extension);
		if(c != null) {
			result = ((ComponentBehaviour)c.findBehaviour(ComponentBehaviour.class)).deploy(parameters);
		} else {
			throw new ManagementException("Impossible to find component to deploy this kind of resources:" + fileURL);
		}
		return result;
	}

	@Override
	public List<String> getSupportedResourcesExtensions() {
		List<String> res = new ArrayList<String>();
		for(Component c: this.getComponents()) {
			res.addAll(((ComponentBehaviour)c.findBehaviour(ComponentBehaviour.class)).getSupportedResourcesExtensions());
		}
		return res;
	}

	@Override
	public Endpoint<?>[] findEndpointsByBehaviour(
			Class<? extends EndpointBehaviour> clazz) throws ESBException {
		List<Endpoint<?>> eps = new ArrayList<Endpoint<?>>();
		for(Component c : this.components) {
			if(hasBehaviour(c, clazz)) {
				eps.add(c);
			}
			for(Service s: ((ComponentBehaviour)c.findBehaviour(ComponentBehaviour.class)).getServices()) {
				if(hasBehaviour(s, clazz)) {
					eps.add(s);
				}
				for(ProviderEndpoint pe: s.getEndpoints()) {
					if(hasBehaviour(pe, clazz)) {
						eps.add(pe);
					}
				}
			}
		}
		
		if(hasBehaviour(this.endpoint, clazz)) {
			eps.add(this.endpoint);
		}
		for(Service s: this.getServices()) {
			if(hasBehaviour(s, clazz)) {
				eps.add(s);
			}
			for(ProviderEndpoint pe: s.getEndpoints()) {
				if(hasBehaviour(pe, clazz)) {
					eps.add(pe);
				}
			}
		}
		return eps.toArray(new Endpoint<?>[eps.size()]);
	}

	private boolean hasBehaviour(Endpoint<?> ep,
			Class<? extends EndpointBehaviour> clazz) throws ESBException {
		for(EndpointBehaviour b: ep.getBehaviours()) {
			if(b.getClass().getName().equals(clazz.getName())) {
				return true;
			}
		}
		return false;
	}


}
