/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.soa.impl.transport;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Header;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.RoleType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.ClientEndpointInvocationInterceptor;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryService;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.transport.Stub;
import com.ebmwebsourcing.easyesb.soa.api.transport.TransportersManager;
import com.ebmwebsourcing.easyesb.soa.api.transport.WakeUpKey;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.transport.WakeUpKeyImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.SourceNodeInformations;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class StubImpl
implements Stub {
    private static Logger log = Logger.getLogger(StubImpl.class.getName());
    private ClientEndpoint clientEndpoint;
    private WakeUpKey locked = new WakeUpKeyImpl();
    private List<ClientEndpointInvocationInterceptor> invocationInterceptors = new ArrayList<ClientEndpointInvocationInterceptor>();

    public StubImpl(ClientEndpoint consumerEndpoint) {
        this.clientEndpoint = consumerEndpoint;
    }

    public TransportersManager getTransportersManager() throws ESBException {
        return this.clientEndpoint.getNode().getTransportersManager();
    }

    public Exchange createExchange() throws ExchangeException {
        Exchange res = (Exchange)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Exchange.class);
        res.setUuid(UUID.randomUUID().toString());
        res.setRole(RoleType.CONSUMER);
        res.setStatus(StatusType.ACTIVE);
        res.setSourceReference(this.clientEndpoint.getReference());
        res.setPattern(PatternType.IN_OUT);
        MessageUtil.getInstance().createInMessageStructure(res);
        return res;
    }

    public void send(Exchange exchange) throws TransportException {
        log.finest("exchange sent to " + exchange.getDestinationReference() + ":\n" + exchange);
        try {
            String operationName;
            for (ClientEndpointInvocationInterceptor ceii : this.invocationInterceptors) {
                ceii.processingExchangeBeforeSending(exchange);
            }
            EndpointType destination = null;
            RegistryService registryService = ((NodeBehaviour)this.clientEndpoint.getNode().findBehaviour(NodeBehaviour.class)).getRegistryService();
            if (registryService != null) {
                try {
                    destination = ((RegistryEndpointBehaviour)((RegistryServiceBehaviour)registryService.findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getEndpoint(exchange.getDestinationReference());
                }
                catch (ESBException e) {
                    throw new TransportException("Impossible to find node having this endpoint: " + exchange.getDestinationReference(), (Throwable)e);
                }
                if (destination == null) {
                    throw new TransportException("Impossible to find node having this endpoint: " + exchange.getDestinationReference());
                }
            } else {
                try {
                    destination = ((Endpoint)SCAHelper.getSCAHelper().getFirstComponentByName(this.clientEndpoint.getNode().getComponent(), exchange.getDestinationReference().toString()).getFcInterface("service")).getModel();
                }
                catch (SCAException e) {
                    throw new TransportException("Impossible to find node having this endpoint: " + exchange.getDestinationReference(), (Throwable)e);
                }
                catch (NoSuchInterfaceException e) {
                    throw new TransportException("Impossible to find node having this endpoint: " + exchange.getDestinationReference(), (Throwable)e);
                }
                if (destination == null) {
                    throw new TransportException("Impossible to find node having this endpoint: " + exchange.getDestinationReference());
                }
            }
            if (destination instanceof ProviderEndpointType) {
                exchange.setServiceName(((ProviderEndpointType)destination).getServiceName());
            }
            if ((operationName = exchange.getOperation()) == null) {
                throw new TransportException("Impossible to send message without operation");
            }
            try {
                QName.valueOf(operationName);
            }
            catch (IllegalArgumentException e) {
                throw new TransportException("The operation name must be a qname!!!");
            }
            try {
                SourceNodeInformations sourceNodeInfos = (SourceNodeInformations)this.clientEndpoint.getNode().getModel().getBasicNodeInformations().duplicateXmlObjectAs(SourceNodeInformations.class);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ((XmlObjectWriter)SOAUtil.getInstance().getWriter((Framework)EasyESBFramework.getInstance()).get()).writeDocument((XmlObject)sourceNodeInfos, (OutputStream)baos);
                ByteArrayInputStream writtenStream = new ByteArrayInputStream(baos.toByteArray());
                Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(writtenStream);
                if (exchange.getMessageIn().getHeader() == null) {
                    Header header = (Header)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Header.class);
                    exchange.getMessageIn().setHeader(header);
                }
                exchange.getMessageIn().getHeader().addProperty(doc);
                this.getTransportersManager().push(exchange, destination.getNode());
                baos.close();
            }
            catch (ESBException e) {
                throw new TransportException((Throwable)e);
            }
            catch (SAXException e) {
                throw new TransportException((Throwable)e);
            }
            catch (IOException e) {
                throw new TransportException((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new TransportException((Throwable)e);
            }
            catch (XmlObjectWriteException e) {
                throw new TransportException((Throwable)e);
            }
            for (ClientEndpointInvocationInterceptor ceii : this.invocationInterceptors) {
                ceii.processingExchangeAfterReceiving(exchange);
            }
        }
        catch (ESBException e1) {
            throw new TransportException((Throwable)e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exchange sendSync(Exchange exchange, long timeout) throws TransportException {
        String operationName;
        EndpointType destination;
        Exchange res;
        block50: {
            log.finest("exchange sent to " + exchange.getDestinationReference() + ": " + exchange.getOperation());
            for (ClientEndpointInvocationInterceptor ceii : this.invocationInterceptors) {
                ceii.processingExchangeBeforeSending(exchange);
            }
            res = null;
            destination = null;
            try {
                RegistryService registryService = ((NodeBehaviour)this.clientEndpoint.getNode().findBehaviour(NodeBehaviour.class)).getRegistryService();
                if (ESBUtil.getURIWithoutQuery((URI)exchange.getDestinationReference()).equals(ESBUtil.getURIWithoutQuery((URI)this.clientEndpoint.getNode().getReference()))) {
                    destination = this.clientEndpoint.getNode().getModel();
                    break block50;
                }
                if (registryService != null) {
                    try {
                        destination = ((RegistryEndpointBehaviour)((RegistryServiceBehaviour)registryService.findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getEndpoint(exchange.getDestinationReference());
                    }
                    catch (ESBException e) {
                        throw new TransportException("Impossible to find node having this endpoint: " + exchange.getDestinationReference(), (Throwable)e);
                    }
                    if (destination == null) {
                        throw new TransportException("Impossible to find node having this endpoint: " + exchange.getDestinationReference());
                    }
                    break block50;
                }
                try {
                    destination = ((Endpoint)SCAHelper.getSCAHelper().getFirstComponentByName(this.clientEndpoint.getNode().getComponent(), exchange.getDestinationReference().toString()).getFcInterface("service")).getModel();
                }
                catch (SCAException e) {
                    throw new TransportException("Impossible to find node having this endpoint: " + exchange.getDestinationReference(), (Throwable)e);
                }
                catch (NoSuchInterfaceException e) {
                    throw new TransportException("Impossible to find node having this endpoint: " + exchange.getDestinationReference(), (Throwable)e);
                }
                if (destination == null) {
                    throw new TransportException("Impossible to find node having this endpoint: " + exchange.getDestinationReference());
                }
            }
            catch (ESBException e1) {
                throw new TransportException((Throwable)e1);
            }
        }
        if (destination instanceof ProviderEndpointType) {
            exchange.setServiceName(((ProviderEndpointType)destination).getServiceName());
        }
        if ((operationName = exchange.getOperation()) == null) {
            throw new TransportException("Impossible to send message without operation");
        }
        try {
            QName.valueOf(operationName);
        }
        catch (IllegalArgumentException e) {
            throw new TransportException("The operation name must be a qname!!!");
        }
        Document sourceNode = null;
        try {
            SourceNodeInformations sourceNodeInfos = (SourceNodeInformations)this.clientEndpoint.getNode().getModel().getBasicNodeInformations().duplicateXmlObjectAs(SourceNodeInformations.class);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ((XmlObjectWriter)SOAUtil.getInstance().getWriter((Framework)EasyESBFramework.getInstance()).get()).writeDocument((XmlObject)sourceNodeInfos, (OutputStream)baos);
            ByteArrayInputStream writtenStream = new ByteArrayInputStream(baos.toByteArray());
            sourceNode = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(writtenStream);
            writtenStream.close();
        }
        catch (SAXException e) {
            throw new TransportException((Throwable)e);
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new TransportException((Throwable)e);
        }
        catch (XmlObjectWriteException e) {
            throw new TransportException((Throwable)e);
        }
        if (exchange.getMessageIn().getHeader() == null) {
            Header header = (Header)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Header.class);
            exchange.getMessageIn().setHeader(header);
        }
        exchange.getMessageIn().getHeader().addProperty(sourceNode);
        this.locked.setExchange(null);
        TransportersManager transporter = null;
        try {
            transporter = this.getTransportersManager();
        }
        catch (ESBException e) {
            throw new TransportException((Throwable)e);
        }
        if (transporter != null) {
            try {
                this.getTransportersManager().getStub2awake().put(UUID.fromString(exchange.getUuid()), this.locked);
            }
            catch (ESBException e) {
                throw new TransportException((Throwable)e);
            }
            try {
                Header header;
                QName propertyQName;
                Document doc;
                WakeUpKey e = this.locked;
                synchronized (e) {
                    this.getTransportersManager().push(exchange, destination.getNode());
                    this.locked.wait(timeout);
                }
                res = this.locked.getExchange();
                if (res == null) {
                    throw new TransportException("Timeout exceeded!!!!");
                }
                Document[] documentArray = res.getMessageIn().getHeader().getProperties();
                int n = documentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    doc = documentArray[n2];
                    propertyQName = new QName(doc.getDocumentElement().getNamespaceURI(), doc.getDocumentElement().getLocalName());
                    if (exchange.getMessageIn().getHeader().getProperty(propertyQName) == null) {
                        exchange.getMessageIn().getHeader().addProperty(doc);
                    } else {
                        exchange.getMessageIn().getHeader().removeProperty(propertyQName);
                        exchange.getMessageIn().getHeader().addProperty(doc);
                    }
                    ++n2;
                }
                if (res.getMessageOut() != null && res.getMessageOut().getHeader() != null) {
                    MessageUtil.getInstance().createOutMessageStructure(exchange);
                    if (exchange.getMessageOut().getHeader() == null) {
                        header = (Header)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Header.class);
                        exchange.getMessageOut().setHeader(header);
                    }
                    documentArray = res.getMessageOut().getHeader().getProperties();
                    n = documentArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        doc = documentArray[n2];
                        propertyQName = new QName(doc.getDocumentElement().getNamespaceURI(), doc.getDocumentElement().getLocalName());
                        if (exchange.getMessageOut().getHeader().getProperty(propertyQName) == null) {
                            exchange.getMessageOut().getHeader().addProperty(doc);
                        } else {
                            exchange.getMessageOut().getHeader().removeProperty(propertyQName);
                            exchange.getMessageOut().getHeader().addProperty(doc);
                        }
                        ++n2;
                    }
                }
                if (res.getMessageOut() != null && res.getMessageOut().getBody() != null) {
                    MessageUtil.getInstance().createOutMessageStructure(exchange);
                    exchange.getMessageOut().getBody().setPayload(res.getMessageOut().getBody().getPayload());
                }
                if (res.getMessageError() != null && res.getMessageError().getHeader() != null) {
                    MessageUtil.getInstance().createErrorMessageStructure(exchange);
                    if (exchange.getMessageError().getHeader() == null) {
                        header = (Header)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Header.class);
                        exchange.getMessageError().setHeader(header);
                    }
                    documentArray = res.getMessageError().getHeader().getProperties();
                    n = documentArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        doc = documentArray[n2];
                        propertyQName = new QName(doc.getDocumentElement().getNamespaceURI(), doc.getDocumentElement().getLocalName());
                        if (exchange.getMessageError().getHeader().getProperty(propertyQName) == null) {
                            exchange.getMessageError().getHeader().addProperty(doc);
                        } else {
                            exchange.getMessageError().getHeader().removeProperty(propertyQName);
                            exchange.getMessageError().getHeader().addProperty(doc);
                        }
                        ++n2;
                    }
                }
                if (res.getMessageError() != null && res.getMessageError().getBody() != null) {
                    MessageUtil.getInstance().createErrorMessageStructure(exchange);
                    exchange.getMessageError().getBody().setPayload(res.getMessageError().getBody().getPayload());
                }
                exchange.setStatus(res.getStatus());
                exchange.setRole(res.getRole());
                res = exchange;
            }
            catch (InterruptedException e) {
                throw new TransportException((Throwable)e);
            }
            catch (ESBException e) {
                throw new TransportException((Throwable)e);
            }
            for (ClientEndpointInvocationInterceptor ceii : this.invocationInterceptors) {
                ceii.processingExchangeAfterReceiving(exchange);
            }
        }
        return res;
    }

    public Description getDescriptionOfProviderEndpoint(URI providerName) throws ESBException {
        Description desc;
        block9: {
            desc = null;
            try {
                Endpoint provider = ((RegistryEndpointBehaviour)this.clientEndpoint.getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(providerName);
                if (provider != null) {
                    desc = provider.getDescription();
                    break block9;
                }
                Exchange exchange = this.createExchange();
                exchange.setSourceReference(this.clientEndpoint.getReference());
                exchange.setDestinationReference(providerName);
                exchange.setOperation(new QName("com.ebmwebsourcing.easyesb", "description").toString());
                exchange.setPattern(PatternType.IN_OUT);
                Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                doc.createElement("wsdlDescription");
                MessageUtil.getInstance().createInMessageStructure(exchange);
                exchange.getMessageIn().getBody().setPayload(doc);
                try {
                    Exchange response = this.sendSync(exchange, 0L);
                    assert (response != null);
                    if (!response.hasMessageError()) {
                        desc = (Description)Factory.getInstance().wrap(((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasyESBFramework.getInstance()).get()).readDocument(response.getMessageOut().getBody().getPayload(), Definitions.class));
                    }
                }
                catch (TransportException e) {
                    log.warning(e.getMessage());
                }
            }
            catch (ParserConfigurationException e) {
                throw new ESBException((Throwable)e);
            }
            catch (ExchangeException e) {
                throw new ESBException((Throwable)e);
            }
            catch (XmlObjectReadException e) {
                throw new ESBException((Throwable)e);
            }
        }
        return desc;
    }

    public void addClientEndpointInvocationInterceptor(ClientEndpointInvocationInterceptor i) {
        this.invocationInterceptors.add(i);
    }

    public ClientEndpointInvocationInterceptor removeClientEndpointInvocationInterceptor(ClientEndpointInvocationInterceptor i) {
        return this.invocationInterceptors.remove(i) ? i : null;
    }

    public ClientEndpointInvocationInterceptor[] getClientEndpointInvocationInterceptors() {
        return this.invocationInterceptors.toArray(new ClientEndpointInvocationInterceptor[this.invocationInterceptors.size()]);
    }

    public Exchange pull(URI providerEndpointName, QName nodeEndpointName) throws TransportException {
        Exchange res = null;
        try {
            res = this.getTransportersManager().pull(providerEndpointName, nodeEndpointName);
        }
        catch (ESBException e) {
            throw new TransportException((Throwable)e);
        }
        if (res != null) {
            if (res.getRole() == RoleType.CONSUMER) {
                res.setRole(RoleType.PROVIDER);
            } else {
                res.setRole(RoleType.CONSUMER);
            }
        }
        return res;
    }
}

