/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.impl;



import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyesb.soa10.api.type.ClientProxyEndpointType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbClientProxyEndpointType;


class ClientProxyEndpointTypeImpl extends EndpointTypeImpl<EJaxbClientProxyEndpointType> implements
ClientProxyEndpointType {

	protected ClientProxyEndpointTypeImpl(XmlContext xmlContext, EJaxbClientProxyEndpointType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbClientProxyEndpointType> getCompliantModelClass() {
		return EJaxbClientProxyEndpointType.class;
	}


	@Override
	public QName getProviderServiceName() {
		return this.getModelObject().getProviderServiceName();
	}


	@Override
	public void setProviderServiceName(QName value) {
		this.getModelObject().setProviderServiceName(value);
	}


	@Override
	public boolean hasProviderServiceName() {
		return this.getProviderServiceName() != null;
	}


	@Override
	public QName getProviderEndpointName() {
		return this.getModelObject().getProviderEndpointName();
	}


	@Override
	public void setProviderEndpointName(QName value) {
		this.getModelObject().setProviderEndpointName(value);
	}


	@Override
	public boolean hasProviderEndpointName() {
		return this.getProviderEndpointName() != null;
	}


	@Override
	public String getExternalAddress() {
		return this.getModelObject().getExternalAddress();
	}


	@Override
	public void setExternalAddress(String value) {
		this.getModelObject().setExternalAddress(value);
	}


	@Override
	public boolean hasExternalAddress() {
		return this.getExternalAddress() != null;
	}


}
