/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.impl;



import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.LocalEndpointsGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.element.NeighbourNode;
import com.ebmwebsourcing.easyesb.soa10.api.element.RemoteEndpointsGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.type.RegistryEndpointType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbBasicNodeInformationsType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbRegistryEndpointType;


class RegistryEndpointTypeImpl extends EndpointTypeImpl<EJaxbRegistryEndpointType> implements
RegistryEndpointType {

	protected RegistryEndpointTypeImpl(XmlContext xmlContext, EJaxbRegistryEndpointType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbRegistryEndpointType> getCompliantModelClass() {
		return EJaxbRegistryEndpointType.class;
	}


	@Override
	public QName getService() {
		return this.getModelObject().getServiceName();
	}


	@Override
	public void setService(QName value) {
		this.getModelObject().setServiceName(value);
	}


	@Override
	public boolean hasService() {
		return this.getService() != null;
	}


	@Override
	public String getWsdlDescription() {
		return this.getModelObject().getWsdlDescription();
	}


	@Override
	public void setWsdlDescription(String value) {
		this.getModelObject().setWsdlDescription(value);
	}


	@Override
	public boolean hasWsdlDescription() {
		return this.getWsdlDescription() != null;
	}


	@Override
	public NeighbourNode[] getNeighbourNodes() {
		return createChildrenArray(getModelObject()
				.getNeighbourNode(), EJaxbBasicNodeInformationsType.class,
				ANY_QNAME, NeighbourNode.class);
	}


	@Override
	public void addNeighbourNode(NeighbourNode nn) {
		addToChildren(getModelObject().getNeighbourNode(), nn);
	}


	@Override
	public void removeNeighbourNode(NeighbourNode nn) {
		removeFromChildren(getModelObject().getNeighbourNode(), nn);
	}


	@Override
	public void clearNeighbourNodes() {
		clearChildren(getModelObject().getNeighbourNode(),
				EJaxbBasicNodeInformationsType.class, ANY_QNAME);
	}


	@Override
	public NeighbourNode getNeighbourNodeByName(QName name) {
		NeighbourNode res = null;
		for(NeighbourNode pe: this.getNeighbourNodes()) {
			if(pe.getNodeName().equals(name)) {
				res = pe;
				break;
			}
		}
		return res;
	}


	@Override
	public LocalEndpointsGroupList getLocalEndpointsList() {
		if(getModelObject().getLocalEndpointsGroupList() != null) {
			return this.getXmlContext().getXmlObjectFactory().wrap(getModelObject().getLocalEndpointsGroupList(), LocalEndpointsGroupList.class);
		}
		return null;
	}


	@Override
	public void setLocalEndpointsList(LocalEndpointsGroupList value) {
		setChild(value, LocalEndpointsGroupList.class);
	}

	
	@Override
	public boolean hasLocalEndpointsList() {
		return this.getLocalEndpointsList() != null;
	}
	

	@Override
	public RemoteEndpointsGroupList getRemoteEndpointsList() {
		if(getModelObject().getRemoteEndpointsGroupList() != null) {
			return this.getXmlContext().getXmlObjectFactory().wrap(getModelObject().getRemoteEndpointsGroupList(), RemoteEndpointsGroupList.class);
		}
		return null;
	}


	@Override
	public void setRemoteEndpointsList(RemoteEndpointsGroupList value) {
		setChild(value, RemoteEndpointsGroupList.class);
	}


	@Override
	public boolean hasRemoteEndpointsList() {
		return this.getRemoteEndpointsList() != null;
	}


}
