/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.impl;



import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.TransporterList;
import com.ebmwebsourcing.easyesb.soa10.api.type.BasicNodeInformationsType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbBasicNodeInformationsType;


class BasicNodeInformationsTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbBasicNodeInformationsType> implements
BasicNodeInformationsType {

	protected BasicNodeInformationsTypeImpl(XmlContext xmlContext, EJaxbBasicNodeInformationsType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbBasicNodeInformationsType> getCompliantModelClass() {
		return EJaxbBasicNodeInformationsType.class;
	}


	@Override
	public QName getNodeName() {
		return this.getModelObject().getNodeName();
	}


	@Override
	public void setNodeName(QName value) {
		this.getModelObject().setNodeName(value);
	}


	@Override
	public boolean hasNodeName() {
		return this.getNodeName() != null;
	}


	@Override
	public String getHost() {
		return this.getModelObject().getHost();
	}


	@Override
	public void setHost(String value) {
		this.getModelObject().setHost(value);
	}


	@Override
	public boolean hasHost() {
		return this.getHost() != null;
	}


	@Override
	public String getPort() {
		return this.getModelObject().getPort();
	}


	@Override
	public void setPort(String value) {
		this.getModelObject().setPort(value);
	}


	@Override
	public boolean hasPort() {
		return this.getPort() != null;
	}


	@Override
	public TransporterList getTransporterList() {
		if(getModelObject().getTransporterList() != null) {
			return this.getXmlContext().getXmlObjectFactory().wrap(getModelObject().getTransporterList(), TransporterList.class);
		}
		return null;
	}


	@Override
	public void setTransporterList(TransporterList value) {
		setChild(value, TransporterList.class);
	}


	@Override
	public boolean hasTransporterList() {
		return this.getTransporterList() != null;
	}




}
