/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.impl;



import java.net.URI;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.BasicNodeInformations;
import com.ebmwebsourcing.easyesb.soa10.api.element.BehavioursList;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbEndpointType;


abstract class EndpointTypeImpl<M extends EJaxbEndpointType> extends AbstractJaxbXmlObjectImpl<M> implements
EndpointType {


	protected EndpointTypeImpl(XmlContext xmlContext, M jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public URI getReference() {
		return URI.create(this.getModelObject().getReference());
	}


	@Override
	public void setReference(URI value) {
		this.getModelObject().setReference(value.toString());
	}


	@Override
	public boolean hasReference() {
		return this.getReference() != null;
	}


	@Override
	public QName getNode() {
		return this.getModelObject().getNode();
	}


	@Override
	public void setNode(QName value) {
		this.getModelObject().setNode(value);
	}


	@Override
	public boolean hasNode() {
		return this.getNode() != null;
	}


	@Override
	public String getType() {
		return this.getModelObject().getType();
	}


	@Override
	public void setType(String value) {
		this.getModelObject().setType(value);
	}


	@Override
	public boolean hasType() {
		return this.getType() != null;
	}


	@Override
	public BehavioursList getBehavioursList() {
		if(getModelObject().getBehavioursList() != null) {
			return this.getXmlContext().getXmlObjectFactory().wrap(getModelObject().getBehavioursList(), BehavioursList.class);
		}
		return null;
	}


	@Override
	public void setBehavioursList(BehavioursList value) {
		setChild(value, BehavioursList.class);
	}


	@Override
	public boolean hasBehavioursList() {
		return this.getBehavioursList() != null;
	}


	@Override
	public BasicNodeInformations getBasicNodeInformations() {
		if(getModelObject().getBasicNodeInformations() != null) {
			return this.getXmlContext().getXmlObjectFactory().wrap(getModelObject().getBasicNodeInformations(), BasicNodeInformations.class);
		}
		return null;
	}


	@Override
	public void setBasicNodeInformations(BasicNodeInformations value) {
		setChild(value, BasicNodeInformations.class);
	}


	@Override
	public boolean hasBasicNodeInformations() {
		return this.getBasicNodeInformations() != null;
	}


	@Override
	public EndpointInitialContext getEndpointInitialContext() {
		if(getModelObject().getEndpointInitialContext() != null) {
			return this.getXmlContext().getXmlObjectFactory().wrap(getModelObject().getEndpointInitialContext(), EndpointInitialContext.class);
		}
		return null;
	}


	@Override
	public void setEndpointInitialContext(EndpointInitialContext value) {
		setChild(value, EndpointInitialContext.class);
	}


	@Override
	public boolean hasEndpointInitialContext() {
		return this.getEndpointInitialContext() != null;
	}



}
