/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.impl;



import java.net.URI;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.ProviderEndpointsGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.type.RegistryServiceType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbRegistryServiceType;

class RegistryServiceTypeImpl extends EndpointTypeImpl<EJaxbRegistryServiceType> implements
RegistryServiceType {

	protected RegistryServiceTypeImpl(XmlContext xmlContext, EJaxbRegistryServiceType jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbRegistryServiceType> getCompliantModelClass() {
		return EJaxbRegistryServiceType.class;
	}


	@Override
	public URI getComponentParentReference() {
		return URI.create(this.getModelObject().getComponentParentReference());
	}

	@Override
	public void setComponentParentReference(URI value) {
		this.getModelObject().setComponentParentReference(value.toString());
	}

	@Override
	public boolean hasComponentParentReference() {
		return this.getComponentParentReference() != null;
	}

	@Override
	public ProviderEndpointsGroupList getProviderEndpointsGroupList() {
		if(getModelObject().getProviderEndpointsGroupList() != null) {
			return this.getXmlContext().getXmlObjectFactory().wrap(getModelObject().getProviderEndpointsGroupList(), ProviderEndpointsGroupList.class);
		}
		return null;
	}



	@Override
	public void setProviderEndpointsGroupList(ProviderEndpointsGroupList value) {
		setChild(value, ProviderEndpointsGroupList.class);
	}



	@Override
	public boolean hasProviderEndpointsGroupList() {
		return this.getProviderEndpointsGroupList() != null;
	}

	@Override
	public QName getServiceName() {
		return this.getModelObject().getServiceName();
	}

	@Override
	public void setServiceName(QName value) {
		this.getModelObject().setServiceName(value);
	}

	@Override
	public boolean hasServiceName() {
		return this.getServiceName() != null;
	}

	@Override
	public String getWsdlDescription() {
		return this.getModelObject().getWsdlDescription();
	}

	@Override
	public void setWsdlDescription(String value) {
		this.getModelObject().setWsdlDescription(value);
	}

	@Override
	public boolean hasWsdlDescription() {
		return this.getWsdlDescription() != null;
	}

	@Override
	public String getName() {
		return this.getModelObject().getName();
	}

	@Override
	public void setName(String endpoint) {
		this.getModelObject().setName(endpoint);
	}

	@Override
	public boolean hasName() {
		return this.getName() != null;
	}

}
