package com.ebmwebsourcing.easyesb.cli.impl;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easyesb.cli.api.Command;

import esstar.petalslink.com.service.management._1_0.ManagementException;

public abstract class AbstractCommand<C> implements Command {

	private String name;

	private List<String> attributes; 

	protected C client = null;

	private String result;

	protected int resultCode;

	public final static int SHUTDOWN_CODE = 0;

	public final static int ERROR_CODE = -1;

	public final static int OK_CODE = 1;

	public final static int INVALID_ARGS = -2;

	public final static int NO_CONNECTION = -3;


	private String shortcut;

	private String description;

	public AbstractCommand(C client) {
		this.client = client;
		this.attributes = new ArrayList<String>();
	}


	public int process(List<String> args) {
		int result = OK_CODE;
		if (!validateArgs(args)) {
			result = INVALID_ARGS;
		} else{
			result = doProcess(args);
		}
		return result;
	}

	protected abstract int doProcess(List<String> args);
	protected abstract boolean validateArgs(List<String> args);

	@Override
	public void setName(String name) {
		this.name = name;
	}

	@Override
	public String getName() {
		return this.name;
	}

	@Override
	public void setAttributes(List<String> attrs) {
		this.attributes.clear();
		this.attributes = attrs;
	}

	@Override
	public List<String> getAttributes() {
		return this.attributes;
	}

	public C getClient() throws ManagementException {
		if(client == null) {
			throw new ManagementException("client cannot be null!!");
		}
		return client;
	}

	@Override
	public void setResult(String res) {
		this.result = res;
	}

	@Override
	public String getResult() {
		return this.result;
	}

	public String getShortcut() {
		return shortcut;
	}

	public void setShortcut(String shortcut) {
		this.shortcut = shortcut;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public int getResultCode(){
		return this.resultCode;
	}

}
