/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyevent.impl.client.soap;

import java.util.List;

import javax.xml.namespace.QName;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsstar.jaxb.notification.topics.TopicType;
import com.petalslink.events_api._1.FindEventProducersByElements;
import com.petalslink.events_api._1.FindEventProducersByElementsResponse;
import com.petalslink.events_api._1.FindEventProducersByTopicsRequest;
import com.petalslink.events_api._1.FindEventProducersByTopicsResponse;
import com.petalslink.events_api._1.FindTopics;
import com.petalslink.events_api._1.FindTopicsByElement;
import com.petalslink.events_api._1.FindTopicsByElementResponse;
import com.petalslink.events_api._1.FindTopicsResponse;
import com.petalslink.events_api._1.PublishTopicNamespaceFromDOM;
import com.petalslink.events_api._1.PublishTopicNamespaceFromDOMResponse;
import com.petalslink.events_api._1.PublishTopicNamespaceFromURL;
import com.petalslink.events_api._1.PublishTopicNamespaceFromURLResponse;
import com.petalslink.events_api._1_0.EventsManager;
import com.petalslink.events_api._1_0.FindEventProducersByElementsFault;
import com.petalslink.events_api._1_0.FindEventProducersByTopicsFault;
import com.petalslink.events_api._1_0.FindTopicsByElementFault;
import com.petalslink.events_api._1_0.FindTopicsFault;
import com.petalslink.events_api._1_0.PublishTopicNamespaceFromDOMFault;
import com.petalslink.events_api._1_0.PublishTopicNamespaceFromURLFault;

public class EventManagerClientImplSOAP implements EventsManager {

	private String address = null;

	private SOAPSender soapSender;

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(com.petalslink.events_api._1.ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}

	public EventManagerClientImplSOAP(String address) {
		this.address = address;
		soapSender = new SOAPSender();
	}



	public String getAddress() {
		return address;
	}

	@Override
	public List<QName> findTopicsByElement(QName element)
			throws FindTopicsByElementFault {
		FindTopicsByElementResponse res = new FindTopicsByElementResponse();
		try{
			FindTopicsByElement payload = new FindTopicsByElement();
			payload.setElement(element);

			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://www.petalslink.com/events-api/1.0/findTopicsByElement");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				FindTopicsByElementFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, FindTopicsByElementFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
				throw new FindTopicsByElementFault("Business Fault", fault);
			}

			// get response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, FindTopicsByElementResponse.class);
		} catch (Exception e) {
			throw new FindTopicsByElementFault("Technical Fault", e);
		} 

		return res.getTopic();
	}

	@Override
	public List<TopicType> findTopics(String request) throws FindTopicsFault {
		FindTopicsResponse res = new FindTopicsResponse();
		try{
			FindTopics payload = new FindTopics();
			payload.setRequest(request);

			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://www.petalslink.com/events-api/1.0/findTopics");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				FindTopicsFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, FindTopicsFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
				throw new FindTopicsFault("Business Fault", fault);
			}

			// get response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, FindTopicsResponse.class);
		} catch (Exception e) {
			throw new FindTopicsFault("Technical Fault", e);
		} 

		return res.getTopic();
	}

	@Override
	public PublishTopicNamespaceFromDOMResponse publishTopicNamespaceFromDOM(
			PublishTopicNamespaceFromDOM parameters)
					throws PublishTopicNamespaceFromDOMFault {
		PublishTopicNamespaceFromDOMResponse res = new PublishTopicNamespaceFromDOMResponse();
		try{

			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://www.petalslink.com/events-api/1.0/publishTopicNamespaceFromDOM");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				throw new PublishTopicNamespaceFromDOMFault("Business Fault:\n" + XMLPrettyPrinter.prettyPrint(soapResponse));
			}

			// get response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, PublishTopicNamespaceFromDOMResponse.class);
		} catch (Exception e) {
			throw new PublishTopicNamespaceFromDOMFault("Technical Fault", e);
		} 

		return res;
	}

	@Override
	public PublishTopicNamespaceFromURLResponse publishTopicNamespaceFromURL(
			PublishTopicNamespaceFromURL parameters)
					throws PublishTopicNamespaceFromURLFault {
		PublishTopicNamespaceFromURLResponse res = new PublishTopicNamespaceFromURLResponse();
		try{

			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://www.petalslink.com/events-api/1.0/publishTopicNamespaceFromURL");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				throw new PublishTopicNamespaceFromURLFault("Business Fault:\n" + XMLPrettyPrinter.prettyPrint(soapResponse));
			}

			// get response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, PublishTopicNamespaceFromURLResponse.class);
		} catch (Exception e) {
			throw new PublishTopicNamespaceFromURLFault("Technical Fault", e);
		} 

		return res;
	}

	@Override
	public FindEventProducersByTopicsResponse findEventProducersByTopics(
			FindEventProducersByTopicsRequest body)
					throws FindEventProducersByTopicsFault {
		FindEventProducersByTopicsResponse res = new FindEventProducersByTopicsResponse();
		try{

			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(body));

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://www.petalslink.com/events-api/1.0/findEventProducersByTopics");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				System.out.println("response fault: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					FindEventProducersByTopicsFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, FindEventProducersByTopicsFault.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new FindEventProducersByTopicsFault("Business Fault", fault);
				} else {
					throw new FindEventProducersByTopicsFault("Technical Fault: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, FindEventProducersByTopicsResponse.class);
		} catch (Exception e) {
			throw new FindEventProducersByTopicsFault("Technical Fault", e);
		} 

		return res;
	}

	@Override
	public FindEventProducersByElementsResponse findEventProducersByElements(
			FindEventProducersByElements parameters)
					throws FindEventProducersByElementsFault {
		FindEventProducersByElementsResponse res = new FindEventProducersByElementsResponse();
		try{

			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://www.petalslink.com/events-api/1.0/findEventProducersByElements");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				FindEventProducersByElementsFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, FindEventProducersByElementsFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
				throw new FindEventProducersByElementsFault("Business Fault", fault);
			}

			// get response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, FindEventProducersByElementsResponse.class);
		} catch (Exception e) {
			throw new FindEventProducersByElementsFault("Technical Fault", e);
		} 

		return res;
	}



}

