package com.ebmwebsourcing.easyevent.impl;

import org.jdom.JDOMException;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyevent.AbstractEventSender;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;

public class SOAPEventSender extends AbstractEventSender {

	private SOAPSender soapSender = new SOAPSender();

	public SOAPEventSender(String externalAddr) {
		super(externalAddr);
	}

	@Override
	public SubscribeResponse subscribe(EndpointReferenceType epr,
			Subscribe subscribeRequest) throws UnacceptableInitialTerminationTimeFault, TopicExpressionDialectUnknownFault,
			InvalidTopicExpressionFault, NotifyMessageNotSupportedFault, TopicNotSupportedFault,
			UnsupportedPolicyRequestFault, ResourceUnknownFault, InvalidFilterFault,
			InvalidProducerPropertiesExpressionFault, UnrecognizedPolicyRequestFault,
			InvalidMessageContentExpressionFault, SubscribeCreationFailedFault {
		SubscribeResponse res = null;
		try{


			Document soapRequest = SOAPSender.createSOAPMessageRequest(Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(subscribeRequest));
			System.out.println("SOAPEventSender: subscribe soapRequest\n" + XMLPrettyPrinter.prettyPrint(soapRequest));
			System.out.println("send to: " + epr.getAddress().getValue().toString());
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, epr.getAddress().getValue().toString(), null);
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				TopicNotSupportedFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, TopicNotSupportedFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
				throw new TopicNotSupportedFault("Business Fault", fault);
			}

			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = Wsnb4ServUtils.getWsnbReader().readSubscribeResponse(doc);
		} catch (Exception e) {
			throw new TopicNotSupportedFault("Technical Fault", e);
		} 

		return res;
	}

	@Override
	public void notify(EndpointReferenceType epr, Notify notify)  {
		try {
			Document soapRequest = SOAPSender.createSOAPMessageRequest(Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify));
			System.out.println("SOAPEventSender: notify\n" + XMLPrettyPrinter.prettyPrint(soapRequest));
			soapSender.sendSoapRequest(soapRequest, epr.getAddress().getValue().toString(), null);
		} catch (WsnbException e) {
			// do nothing
			e.printStackTrace();
		} catch (SOAPException e) {
			// do nothing
			e.printStackTrace();
		} catch (JDOMException e) {
			// do nothing
			e.printStackTrace();
		}

	}

}
