/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyevent;

import com.ebmwebsourcing.easycommons.research.util.easybox.DefaultFramework;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyevent.impl.client.soap.EventManagerClientImplSOAP;
import com.ebmwebsourcing.wsaddressing10.api.element.Address;
import com.ebmwebsourcing.wsaddressing10.api.element.EndpointReference;
import com.petalslink.events_api._1.FindEventProducersByTopicsRequest;
import com.petalslink.events_api._1.FindEventProducersByTopicsResponse;
import com.petalslink.events_api._1_0.FindEventProducersByTopicsFault;
import easybox.org.w3._2005._08.addressing.EJaxbEndpointReferenceType;
import easybox.org.w3._2005._08.addressing.ObjectFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public abstract class AbstractProducersLocalisationManager {
    private static Logger LOG = Logger.getLogger(AbstractProducersLocalisationManager.class.getName());
    protected List<EndpointReference> eventRegistries = Collections.synchronizedList(new ArrayList());
    protected Map<QName, List<EndpointReference>> producersMap = Collections.synchronizedMap(new HashMap());
    private ObjectFactory eprFactory = new ObjectFactory();

    public List<EndpointReference> getProducers(QName topic) {
        List<EndpointReference> res = this.producersMap.get(topic);
        if (res == null || res.size() == 0) {
            this.findProducers(topic);
            res = this.producersMap.get(topic);
        }
        return res;
    }

    public void addProducer(QName topic, String epr) {
        List<EndpointReference> res = this.producersMap.get(topic);
        if (res == null) {
            res = new ArrayList<EndpointReference>();
        }
        EndpointReference ref = (EndpointReference)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(EndpointReference.class);
        ref.setAddress((Address)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(Address.class));
        ref.getAddress().setValue(URI.create(epr));
        res.add(ref);
        this.producersMap.put(topic, res);
    }

    public void findProducers(QName topic) {
        try {
            this.findProducersInExternalEnvironment(topic);
            List<EndpointReference> res = this.producersMap.get(topic);
            if (res == null || res.size() == 0) {
                LOG.finest("Find in event registry");
                for (EndpointReference eventRegistryAddress : this.eventRegistries) {
                    LOG.finest("Find in event registry: eventRegistryAddress = " + eventRegistryAddress.getAddress().getValue());
                    EventManagerClientImplSOAP client = new EventManagerClientImplSOAP(eventRegistryAddress.getAddress().getValue().toString());
                    FindEventProducersByTopicsRequest request = new FindEventProducersByTopicsRequest();
                    request.getTopic().add(topic);
                    FindEventProducersByTopicsResponse response = client.findEventProducersByTopics(request);
                    LOG.finest("response = " + response);
                    List<EndpointReference> eprs = this.producersMap.get(topic);
                    if (eprs == null) {
                        eprs = new ArrayList<EndpointReference>();
                    }
                    if (response != null) {
                        for (EJaxbEndpointReferenceType eprJaxb : response.getEndpointReference()) {
                            EndpointReference epr = (EndpointReference)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().wrap((Object)this.eprFactory.createEndpointReference(eprJaxb));
                            eprs.add(epr);
                        }
                    }
                    this.producersMap.put(topic, eprs);
                }
            }
        }
        catch (FindEventProducersByTopicsFault e) {
            e.printStackTrace();
        }
    }

    public void addEventRegitry(String address) {
        EndpointReference ref = (EndpointReference)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(EndpointReference.class);
        ref.setAddress((Address)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(Address.class));
        ref.getAddress().setValue(URI.create(address));
        this.eventRegistries.add(ref);
    }

    public void removeEventRegitry(String address) {
        EndpointReference epr = this.getEventRegistry(address);
        this.eventRegistries.remove(epr);
    }

    public List<EndpointReference> getEventRegistries() {
        return this.eventRegistries;
    }

    public EndpointReference getEventRegistry(String address) {
        for (EndpointReference epr : this.eventRegistries) {
            if (!epr.getAddress().getValue().toString().equals(address)) continue;
            return epr;
        }
        return null;
    }

    public abstract void findProducersInExternalEnvironment(QName var1);
}

