package com.ebmwebsourcing.easyschema.xsd2xml;

import java.util.HashMap;
import java.util.Map;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easyschema10.api.SchemaOfSchemas;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.type.Form;

public abstract class XSD2XML {

    public static XSD2XML newInstance() {
        return new XSD2XMLImpl();
    }

    public abstract String printXml(final Element e, Object value) /*
                                                                    * throws
                                                                    * SchemaException
                                                                    */;

    public abstract String printXml(final Element e, Map<com.ebmwebsourcing.easyschema10.api.type.Type, Object> value,
            boolean createOptionalElement, boolean createOptionalAttribute);

    public abstract org.jdom.Element generateElement(final Element eIn,
            XmlObject typeHolderXmlObject, 
            final Object values);

    public abstract org.jdom.Element generateElement(com.ebmwebsourcing.easyschema10.api.element.Element eIn,
            XmlObject typeHolderXmlObject,
            Map<com.ebmwebsourcing.easyschema10.api.type.Type, Object> values, Form form, int minOccurs,
            boolean createOptionalElement, boolean createOptionalAttribute);

    public abstract org.jdom.Element addMinOccursEqual0OrArrayElement(
            final Element childDefinition, XmlObject typeHolderXmlObject, 
            final org.jdom.Element parentElement);

    public static Map<com.ebmwebsourcing.easyschema10.api.type.Type, Object> createDefaultMap(Object value) {
        Map<com.ebmwebsourcing.easyschema10.api.type.Type, Object> values = 
            new HashMap<com.ebmwebsourcing.easyschema10.api.type.Type, Object>();
        for (com.ebmwebsourcing.easyschema10.api.type.Type type : SchemaOfSchemas.getSchema().getSimpleTypes()) {
            values.put(type, value);
        }
        return values;
    }
}
