package org.petalslink.abslayer.service.impl.wsdl11;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Interface;

import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easyplnk20.api.element.Role;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.easywsdl11.api.element.Service;

public class RoleImpl implements org.petalslink.abslayer.service.api.Role {

    private final Role model;

    private RoleImpl(Role model) {
        this.model = model;
    }

    @Override
    public String getName() {
        return model.getName();
    }

    // @Override
    // public Interface getInterface() {

    @Override
    public QName getInterfaceQName() {
        return model.getPortType();
        // // TODO : we should rather go up to bpel process to look for
        // interface
        // XmlObject xmlObject = model.getXmlObjectBaseRoot();
        // if (!(xmlObject instanceof Definitions)) return null;
        // Definitions definitions = (Definitions) xmlObject;
        // assert
        // model.getPortType().getNamespaceURI().equals(definitions.getTargetNamespace());
        // return new
        // InterfaceImpl(definitions.getPortTypeByName(model.getPortType().getLocalPart()));
    }

	@Override
	public Interface findInterface(QName qname) {
        assert qname != null;
        XmlObjectXPathEvaluator xpathEvaluator = model.getXmlContext()
                .createXPathEvaluator();
        try {
        	PortType result = xpathEvaluator
                    .selectSingleXmlObjectNode(
                            model,
                            String.format(
                                    "//wsdl11:portType[@name='%s'][parent::wsdl11:definitions/@targetNamespace='%s']",
                                    qname.getLocalPart(),
                                    qname.getNamespaceURI()), PortType.class);
            if (result == null)
                return null;
            return (org.petalslink.abslayer.service.api.Interface) Factory.getInstance().wrap(result);
        } catch (XPathExpressionException xee) {
            throw new UncheckedException(xee);
        }
	}

}
