package org.petalslink.abslayer.service.impl.wsdl11;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Fault;
import org.petalslink.abslayer.service.api.Input;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Output;

import com.ebmwebsourcing.easywsdl11.api.WsdlHelper;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;

public class OperationImpl implements org.petalslink.abslayer.service.api.Operation {

    private final com.ebmwebsourcing.easywsdl11.api.element.Operation model;

    private Fault[] faults;
    private Input input;
    private Output output;

    private OperationImpl(
            com.ebmwebsourcing.easywsdl11.api.element.Operation model) {
        this.model = model;
    }

    @Override
    public String getName() {
        return model.getName();
    }
    
	@Override
	public QName inferQName() {
		return new QName(WsdlHelper.findParentDefinitions(this.model).getTargetNamespace(),this.model.getName());
	}

    @Override
    public Fault[] getFaults() {
        if (faults == null) {
            com.ebmwebsourcing.easywsdl11.api.element.Fault[] opFaults = model
                    .getFaults();
            faults = new Fault[opFaults.length];
            int i = 0;
            for (com.ebmwebsourcing.easywsdl11.api.element.Fault fault : opFaults) {
                assert fault != null;
                faults[i] = (org.petalslink.abslayer.service.api.Fault) Factory.getInstance().wrap(fault);
                ++i;
            }
        }
        return faults;
    }

    @Override
    public Input getInput() {
        if (input == null) {
            com.ebmwebsourcing.easywsdl11.api.element.Input inp = model
                    .getInput();
            if (inp != null) {
                input = (org.petalslink.abslayer.service.api.Input) Factory.getInstance().wrap(inp);
            }
        }
        return input;
    }

    @Override
    public Output getOutput() {
        if (output == null) {
            com.ebmwebsourcing.easywsdl11.api.element.Output out = model
                    .getOutput();
            if (out != null) {
                output = (org.petalslink.abslayer.service.api.Output) Factory.getInstance().wrap(out);
            }
        }
        return output;
    }

    @Override
    public Interface getParentInterface() {
        return (org.petalslink.abslayer.service.api.Interface) Factory.getInstance().wrap((PortType) model.getXmlObjectParent());
    }
    
    @Override
    public com.ebmwebsourcing.easywsdl11.api.element.Operation getModel(){
    	return model;
    }

}
