/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.abslayer;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.petalslink.abslayer.FactoryProvider;

public final class Factory {
    private static final Factory INSTANCE;
    private final Map<Class<?>, Constructor<?>> constructorsFromModelMap = new HashMap();

    Factory(Iterable<FactoryProvider> providers) {
        for (FactoryProvider provider : providers) {
            this.constructorsFromModelMap.putAll(provider.getConstructorsFromModelMap());
        }
    }

    public static Factory getInstance() {
        return INSTANCE;
    }

    public Object wrap(XmlObject obj) {
        if (obj.hasUserData()) {
            return obj.getUserData();
        }
        Class xmlObjectInterfaceClass = (Class)obj.getXmlContext().getClassMetadata().get(obj.getClass(), "implementationClassInterface");
        assert (xmlObjectInterfaceClass != null);
        Constructor<?> constructor = this.constructorsFromModelMap.get(xmlObjectInterfaceClass);
        assert (constructor != null) : String.format("Cannot wrap instances of class '%s'.", xmlObjectInterfaceClass);
        try {
            Object o = constructor.newInstance(obj);
            obj.setUserData(o);
            return o;
        }
        catch (IllegalArgumentException e) {
            throw new UncheckedException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new UncheckedException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new UncheckedException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    static {
        ServiceLoader<FactoryProvider> sl = ServiceLoader.load(FactoryProvider.class);
        INSTANCE = new Factory(sl);
    }
}

